/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.accessor;

import java.util.Collection;
import java.util.Map;
import org.apache.qpid.server.query.engine.exception.QueryEvaluationException;
import org.apache.qpid.server.query.engine.parsing.expression.AbstractExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.Expression;
import org.apache.qpid.server.query.engine.parsing.expression.accessor.CollectionObjectAccessor;
import org.apache.qpid.server.query.engine.parsing.expression.accessor.DelegatingObjectAccessor;
import org.apache.qpid.server.query.engine.parsing.expression.accessor.MapObjectAccessor;

public class DelegatingCollectionAccessorExpression<T, R, INDEX, COLLECTION extends Collection<R>, MAP extends Map<String, R>>
extends AbstractExpressionNode<T, R> {
    private final String _property;
    private final Expression<T, INDEX> _index;

    public DelegatingCollectionAccessorExpression(String alias, String property, Expression<T, INDEX> index) {
        super(alias);
        this._property = property;
        this._index = index;
    }

    @Override
    public R apply(T value) {
        INDEX pointer = this._index.apply(value);
        if (pointer instanceof Number) {
            DelegatingObjectAccessor accessor = new DelegatingObjectAccessor(this.getAlias(), this._property);
            Collection collection = (Collection)accessor.apply(value);
            int index = ((Number)pointer).intValue();
            return new CollectionObjectAccessor(index).apply(collection);
        }
        if (pointer instanceof String) {
            DelegatingObjectAccessor accessor = new DelegatingObjectAccessor(this.getAlias(), this._property);
            Map map = (Map)accessor.apply(value);
            String key = (String)pointer;
            return new MapObjectAccessor(key).apply(map);
        }
        throw QueryEvaluationException.fieldNotFound(this._property);
    }
}

