/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.api.EncryptionContext;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public interface Message<T> {
    public Map<String, String> getProperties();

    public boolean hasProperty(String var1);

    public String getProperty(String var1);

    public byte[] getData();

    public int size();

    public T getValue();

    public MessageId getMessageId();

    public long getPublishTime();

    public long getEventTime();

    public long getSequenceId();

    public String getProducerName();

    public boolean hasKey();

    public String getKey();

    public boolean hasBase64EncodedKey();

    public byte[] getKeyBytes();

    public boolean hasOrderingKey();

    public byte[] getOrderingKey();

    public String getTopicName();

    public Optional<EncryptionContext> getEncryptionCtx();

    public int getRedeliveryCount();

    public byte[] getSchemaVersion();

    public Optional<byte[]> getSchemaId();

    default public Optional<Schema<?>> getReaderSchema() {
        return Optional.empty();
    }

    public boolean isReplicated();

    public String getReplicatedFrom();

    public void release();

    public boolean hasBrokerPublishTime();

    public Optional<Long> getBrokerPublishTime();

    public boolean hasIndex();

    public Optional<Long> getIndex();
}

