/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.service.Producer;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.common.policies.data.stats.NonPersistentPublisherStatsImpl;
import org.apache.pulsar.common.policies.data.stats.PublisherStatsImpl;

public class OpenTelemetryProducerStats
implements AutoCloseable {
    public static final String MESSAGE_IN_COUNTER = "pulsar.broker.producer.message.incoming.count";
    private final ObservableLongMeasurement messageInCounter;
    public static final String BYTES_IN_COUNTER = "pulsar.broker.producer.message.incoming.size";
    private final ObservableLongMeasurement bytesInCounter;
    public static final String MESSAGE_DROP_COUNTER = "pulsar.broker.producer.message.drop.count";
    private final ObservableLongMeasurement messageDropCounter;
    private final BatchCallback batchCallback;

    public OpenTelemetryProducerStats(PulsarService pulsar) {
        Meter meter = pulsar.getOpenTelemetry().getMeter();
        this.messageInCounter = meter.counterBuilder(MESSAGE_IN_COUNTER).setUnit("{message}").setDescription("The total number of messages received from this producer.").buildObserver();
        this.bytesInCounter = meter.counterBuilder(BYTES_IN_COUNTER).setUnit("By").setDescription("The total number of messages bytes received from this producer.").buildObserver();
        this.messageDropCounter = meter.counterBuilder(MESSAGE_DROP_COUNTER).setUnit("{message}").setDescription("The total number of messages dropped from this producer.").buildObserver();
        this.batchCallback = meter.batchCallback(() -> pulsar.getBrokerService().getTopics().values().stream().filter(future -> future.isDone() && !future.isCompletedExceptionally()).map(CompletableFuture::join).filter(Optional::isPresent).flatMap(topic -> ((Topic)topic.get()).getProducers().values().stream()).forEach(this::recordMetricsForProducer), (ObservableMeasurement)this.messageInCounter, new ObservableMeasurement[]{this.bytesInCounter, this.messageDropCounter});
    }

    @Override
    public void close() {
        this.batchCallback.close();
    }

    private void recordMetricsForProducer(Producer producer) {
        Attributes attributes = producer.getOpenTelemetryAttributes();
        PublisherStatsImpl stats = producer.getStats();
        this.messageInCounter.record(stats.getMsgInCounter(), attributes);
        this.bytesInCounter.record(stats.getBytesInCounter(), attributes);
        if (stats instanceof NonPersistentPublisherStatsImpl) {
            NonPersistentPublisherStatsImpl nonPersistentStats = (NonPersistentPublisherStatsImpl)stats;
            this.messageDropCounter.record(nonPersistentStats.getMsgDropCount(), attributes);
        }
    }
}

