/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.slogger.slf4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.bookkeeper.slogger.AbstractSlogger;
import org.apache.bookkeeper.slogger.Slogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Slf4jSlogger
extends AbstractSlogger {
    private ThreadLocal<List<String>> mdcKeysTls = new ThreadLocal<List<String>>(){

        @Override
        protected List<String> initialValue() {
            return new ArrayList<String>();
        }
    };
    private final Logger log;

    public Slf4jSlogger(Class<?> clazz) {
        this(clazz, Collections.emptyList());
    }

    Slf4jSlogger() {
        this(Slf4jSlogger.class);
    }

    Slf4jSlogger(Class<?> clazz, Iterable<Object> parent) {
        super(parent);
        this.log = LoggerFactory.getLogger(clazz);
    }

    protected Slogger newSlogger(Optional<Class<?>> clazz, Iterable<Object> parent) {
        return new Slf4jSlogger(clazz.orElse(Slf4jSlogger.class), parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doLog(AbstractSlogger.Level level, Enum<?> event, String message, Throwable throwable, List<Object> keyValues) {
        List<String> mdcKeys = this.mdcKeysTls.get();
        mdcKeys.clear();
        try {
            if (event != null) {
                MDC.put((String)"event", (String)event.toString());
                mdcKeys.add("event");
            }
            for (int i = 0; i < keyValues.size(); i += 2) {
                MDC.put((String)keyValues.get(i).toString(), (String)keyValues.get(i + 1).toString());
                mdcKeys.add(keyValues.get(i).toString());
            }
            String msg = message == null ? event.toString() : message;
            switch (level) {
                case INFO: {
                    this.log.info(msg);
                    return;
                }
                case WARN: {
                    if (throwable != null) {
                        this.log.warn(msg, throwable);
                        return;
                    } else {
                        this.log.warn(msg);
                        return;
                    }
                }
                default: {
                    if (throwable != null) {
                        this.log.error(msg, throwable);
                        return;
                    } else {
                        this.log.error(msg);
                    }
                    return;
                }
            }
        }
        finally {
            for (String key : mdcKeys) {
                MDC.remove((String)key);
            }
            mdcKeys.clear();
        }
    }
}

