/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ExtensionProperty;
import io.swagger.util.Json;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class BaseReaderUtils {
    private BaseReaderUtils() {
    }

    public static Map<String, Object> parseExtensions(Extension[] extensions) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Extension extension : extensions) {
            String name = extension.name();
            String key = name.length() > 0 ? StringUtils.prependIfMissing((String)name, (CharSequence)"x-", (CharSequence[])new CharSequence[0]) : name;
            for (ExtensionProperty property : extension.properties()) {
                String propertyName = property.name();
                String propertyValue = property.value();
                JsonNode processedValue = null;
                boolean propertyAsJson = property.parseValue();
                if (!StringUtils.isNotBlank((CharSequence)propertyName) || !StringUtils.isNotBlank((CharSequence)propertyValue)) continue;
                if (key.isEmpty()) {
                    if (propertyAsJson) {
                        try {
                            processedValue = Json.mapper().readTree(propertyValue);
                            map.put(StringUtils.prependIfMissing((String)propertyName, (CharSequence)"x-", (CharSequence[])new CharSequence[0]), processedValue);
                        }
                        catch (Exception e) {
                            map.put(StringUtils.prependIfMissing((String)propertyName, (CharSequence)"x-", (CharSequence[])new CharSequence[0]), propertyValue);
                        }
                        continue;
                    }
                    map.put(StringUtils.prependIfMissing((String)propertyName, (CharSequence)"x-", (CharSequence[])new CharSequence[0]), propertyValue);
                    continue;
                }
                Object value = map.get(key);
                if (value == null || !(value instanceof Map)) {
                    value = new HashMap();
                    map.put(key, value);
                }
                Map mapValue = (Map)value;
                if (propertyAsJson) {
                    try {
                        processedValue = Json.mapper().readTree(propertyValue);
                        mapValue.put(propertyName, processedValue);
                    }
                    catch (Exception e) {
                        mapValue.put(propertyName, propertyValue);
                    }
                    continue;
                }
                mapValue.put(propertyName, propertyValue);
            }
        }
        return map;
    }
}

