/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.CompletionKey;
import org.apache.bookkeeper.proto.CompletionValue;
import org.apache.bookkeeper.proto.PerChannelBookieClient;

class ReadLacCompletion
extends CompletionValue {
    final BookkeeperInternalCallbacks.ReadLacCallback cb;

    public ReadLacCompletion(final CompletionKey key, final BookkeeperInternalCallbacks.ReadLacCallback originalCallback, Object ctx, long ledgerId, PerChannelBookieClient perChannelBookieClient) {
        super("ReadLAC", ctx, ledgerId, -1L, perChannelBookieClient);
        this.opLogger = perChannelBookieClient.readLacOpLogger;
        this.timeoutOpLogger = perChannelBookieClient.readLacTimeoutOpLogger;
        this.cb = new BookkeeperInternalCallbacks.ReadLacCallback(){

            @Override
            public void readLacComplete(int rc, long ledgerId, ByteBuf lacBuffer, ByteBuf lastEntryBuffer, Object ctx) {
                ReadLacCompletion.this.logOpResult(rc);
                originalCallback.readLacComplete(rc, ledgerId, lacBuffer, lastEntryBuffer, ctx);
                key.release();
            }
        };
    }

    @Override
    public void errorOut() {
        this.errorOut(-8);
    }

    @Override
    public void errorOut(int rc) {
        this.errorOutAndRunCallback(() -> this.cb.readLacComplete(rc, this.ledgerId, null, null, this.ctx));
    }

    @Override
    public void handleV3Response(BookkeeperProtocol.Response response) {
        BookkeeperProtocol.StatusCode status;
        BookkeeperProtocol.ReadLacResponse readLacResponse = response.getReadLacResponse();
        ByteBuf lacBuffer = Unpooled.EMPTY_BUFFER;
        ByteBuf lastEntryBuffer = Unpooled.EMPTY_BUFFER;
        BookkeeperProtocol.StatusCode statusCode = status = response.getStatus() == BookkeeperProtocol.StatusCode.EOK ? readLacResponse.getStatus() : response.getStatus();
        if (readLacResponse.hasLacBody()) {
            lacBuffer = Unpooled.wrappedBuffer((ByteBuffer)readLacResponse.getLacBody().asReadOnlyByteBuffer());
        }
        if (readLacResponse.hasLastEntryBody()) {
            lastEntryBuffer = Unpooled.wrappedBuffer((ByteBuffer)readLacResponse.getLastEntryBody().asReadOnlyByteBuffer());
        }
        if (LOG.isDebugEnabled()) {
            this.logResponse(status, "ledgerId", this.ledgerId);
        }
        int rc = this.convertStatus(status, -1);
        this.cb.readLacComplete(rc, this.ledgerId, lacBuffer.slice(), lastEntryBuffer.slice(), this.ctx);
    }
}

