/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import io.netty.util.Recycler;
import org.apache.bookkeeper.mledger.Position;

public class PositionRecyclable
implements Position {
    private final Recycler.Handle<PositionRecyclable> recyclerHandle;
    private static final Recycler<PositionRecyclable> RECYCLER = new Recycler<PositionRecyclable>(){

        protected PositionRecyclable newObject(Recycler.Handle<PositionRecyclable> recyclerHandle) {
            return new PositionRecyclable(recyclerHandle);
        }
    };
    private long ledgerId;
    private long entryId;

    private PositionRecyclable(Recycler.Handle<PositionRecyclable> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    @Override
    public long getLedgerId() {
        return this.ledgerId;
    }

    @Override
    public long getEntryId() {
        return this.entryId;
    }

    public void recycle() {
        this.ledgerId = -1L;
        this.entryId = -1L;
        this.recyclerHandle.recycle((Object)this);
    }

    public int hashCode() {
        return this.hashCodeForPosition();
    }

    public boolean equals(Object obj) {
        return obj instanceof Position && this.compareTo((Position)obj) == 0;
    }

    public static PositionRecyclable get(long ledgerId, long entryId) {
        PositionRecyclable position = (PositionRecyclable)RECYCLER.get();
        position.ledgerId = ledgerId;
        position.entryId = entryId;
        return position;
    }
}

