/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.component;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.bookkeeper.common.component.Lifecycle;
import org.apache.bookkeeper.common.component.LifecycleComponent;
import org.apache.bookkeeper.common.component.LifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCloseableLifecycleComponent
implements LifecycleComponent {
    private static final Logger LOG = LoggerFactory.getLogger(AutoCloseableLifecycleComponent.class);
    protected final Lifecycle lifecycle = new Lifecycle();
    private final Set<LifecycleListener> listeners = new CopyOnWriteArraySet<LifecycleListener>();
    protected volatile Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final String componentName;
    private final AutoCloseable closeable;

    public AutoCloseableLifecycleComponent(String componentName, AutoCloseable closeable) {
        this.componentName = componentName;
        this.closeable = closeable;
    }

    @Override
    public String getName() {
        return this.componentName;
    }

    @Override
    public void setExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        this.uncaughtExceptionHandler = handler;
    }

    @Override
    public Lifecycle.State lifecycleState() {
        return this.lifecycle.state();
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void start() {
        if (!this.lifecycle.canMoveToStarted()) {
            return;
        }
        this.listeners.forEach(LifecycleListener::beforeStart);
        this.lifecycle.moveToStarted();
        this.listeners.forEach(LifecycleListener::afterStart);
    }

    @Override
    public void stop() {
        if (!this.lifecycle.canMoveToStopped()) {
            return;
        }
        this.listeners.forEach(LifecycleListener::beforeStop);
        this.lifecycle.moveToStopped();
        this.listeners.forEach(LifecycleListener::afterStop);
    }

    @Override
    public void close() {
        if (this.lifecycle.started()) {
            this.stop();
        }
        if (!this.lifecycle.canMoveToClosed()) {
            return;
        }
        this.listeners.forEach(LifecycleListener::beforeClose);
        this.lifecycle.moveToClosed();
        try {
            this.closeable.close();
        }
        catch (Exception e) {
            LOG.warn("failed to close {}", (Object)this.componentName, (Object)e);
        }
        this.listeners.forEach(LifecycleListener::afterClose);
    }
}

