/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.informer.cache;

import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.informer.ListerWatcher;
import io.kubernetes.client.informer.ResyncRunnable;
import io.kubernetes.client.informer.cache.DeltaFIFO;
import io.kubernetes.client.informer.cache.ReflectorRunnable;
import io.kubernetes.client.util.Threads;
import java.util.Deque;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.MutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller<ApiType extends KubernetesObject, ApiListType extends KubernetesListObject> {
    private static final Logger log = LoggerFactory.getLogger(Controller.class);
    private static final long DEFAULT_PERIOD = 1000L;
    private long fullResyncPeriod;
    private DeltaFIFO queue;
    private ListerWatcher<ApiType, ApiListType> listerWatcher;
    private ReflectorRunnable<ApiType, ApiListType> reflector;
    private Supplier<Boolean> resyncFunc;
    private Consumer<Deque<MutablePair<DeltaFIFO.DeltaType, KubernetesObject>>> processFunc;
    private ScheduledExecutorService reflectExecutor;
    private ScheduledExecutorService resyncExecutor;
    private ScheduledFuture resyncFuture;
    private Class<ApiType> apiTypeClass;
    private ScheduledFuture reflectorFuture;
    BiConsumer<Class<ApiType>, Throwable> exceptionHandler;

    public Controller(Class<ApiType> apiTypeClass, DeltaFIFO queue, ListerWatcher<ApiType, ApiListType> listerWatcher, Consumer<Deque<MutablePair<DeltaFIFO.DeltaType, KubernetesObject>>> processFunc, Supplier<Boolean> resyncFunc, long fullResyncPeriod) {
        this(apiTypeClass, queue, listerWatcher, processFunc, resyncFunc, fullResyncPeriod, null);
    }

    public Controller(Class<ApiType> apiTypeClass, DeltaFIFO queue, ListerWatcher<ApiType, ApiListType> listerWatcher, Consumer<Deque<MutablePair<DeltaFIFO.DeltaType, KubernetesObject>>> processFunc, Supplier<Boolean> resyncFunc, long fullResyncPeriod, BiConsumer<Class<ApiType>, Throwable> exceptionHandler) {
        this.queue = queue;
        this.listerWatcher = listerWatcher;
        this.apiTypeClass = apiTypeClass;
        this.processFunc = processFunc;
        this.resyncFunc = resyncFunc;
        this.fullResyncPeriod = fullResyncPeriod;
        this.exceptionHandler = exceptionHandler;
        this.reflectExecutor = Executors.newSingleThreadScheduledExecutor(Threads.threadFactory("controller-reflector-" + apiTypeClass.getName() + "-%d"));
        this.resyncExecutor = Executors.newSingleThreadScheduledExecutor(Threads.threadFactory("controller-resync-" + apiTypeClass.getName() + "-%d"));
    }

    public Controller(Class<ApiType> apiTypeClass, DeltaFIFO queue, ListerWatcher<ApiType, ApiListType> listerWatcher, Consumer<Deque<MutablePair<DeltaFIFO.DeltaType, KubernetesObject>>> popProcessFunc) {
        this(apiTypeClass, queue, listerWatcher, popProcessFunc, null, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        log.info("informer#Controller: ready to run resync & reflector runnable");
        if (this.fullResyncPeriod > 0L) {
            ResyncRunnable resyncRunnable = new ResyncRunnable(this.queue, this.resyncFunc);
            this.resyncFuture = this.resyncExecutor.scheduleAtFixedRate(resyncRunnable::run, this.fullResyncPeriod, this.fullResyncPeriod, TimeUnit.MILLISECONDS);
        } else {
            log.info("informer#Controller: resync skipped due to 0 full resync period");
        }
        Controller controller = this;
        synchronized (controller) {
            this.reflector = this.newReflector();
            try {
                this.reflectorFuture = this.reflectExecutor.scheduleWithFixedDelay(this.reflector::run, 0L, 1000L, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException e) {
                log.warn("reflector list-watching job exiting because the thread-pool is shutting down");
                return;
            }
        }
        this.processLoop();
    }

    ReflectorRunnable<ApiType, ApiListType> newReflector() {
        return new ReflectorRunnable<ApiType, ApiListType>(this.apiTypeClass, this.listerWatcher, this.queue, this.exceptionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Controller controller = this;
        synchronized (controller) {
            if (this.reflectorFuture != null) {
                this.reflector.stop();
                this.reflectorFuture.cancel(true);
            }
        }
        this.reflectExecutor.shutdown();
        this.resyncExecutor.shutdown();
    }

    public boolean hasSynced() {
        return this.queue.hasSynced();
    }

    public String lastSyncResourceVersion() {
        if (this.reflector == null) {
            return "";
        }
        return this.reflector.getLastSyncResourceVersion();
    }

    private void processLoop() {
        while (true) {
            try {
                while (true) {
                    this.queue.pop(this.processFunc);
                }
            }
            catch (InterruptedException t) {
                log.error("DefaultController#processLoop get interrupted {}", (Object)t.getMessage(), (Object)t);
                return;
            }
            catch (Throwable t) {
                log.error("DefaultController#processLoop recovered from crashing {}", (Object)t.getMessage(), (Object)t);
                continue;
            }
            break;
        }
    }
}

