/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.pinot.controller.recommender.rules;

import org.apache.pinot.controller.recommender.exceptions.InvalidInputException;
import org.apache.pinot.controller.recommender.io.ConfigManager;
import org.apache.pinot.controller.recommender.io.InputManager;


/**
 * Interface for a rule
 */
public abstract class AbstractRule {
  protected InputManager _input;
  protected ConfigManager _output;

  public abstract void run()
      throws InvalidInputException;

  public AbstractRule(InputManager input, ConfigManager output) {
    _input = input;
    _output = output;
  }

  /**
   * Some rules have to be run even if user has disabled them. The reason is the output of these rules are used in other
   * rules. This method is used to hide the output from the final result that's going to be presented to the user.
   */
  public void hideOutput() {
  }
}
