/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import java.util.List;

@XmlType(name="listenPort")
public class ListenPortDTO {
    private String portName;
    private int portNumber;
    private String transportProtocol;
    private List<String> applicationProtocols;
    private String componentType;
    private String componentId;
    private String componentName;
    private String componentClass;
    private String parentGroupId;
    private String parentGroupName;

    @Schema(description="The name of the the listen port. Useful context for components that provide multiple ports.")
    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    @Schema(description="The ingress port number")
    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    @Schema(description="The ingress transport protocol (TCP or UDP)")
    public String getTransportProtocol() {
        return this.transportProtocol;
    }

    public void setTransportProtocol(String transportProtocol) {
        this.transportProtocol = transportProtocol;
    }

    @Schema(description="Supported application protocols, if applicable")
    public List<String> getApplicationProtocols() {
        return this.applicationProtocols;
    }

    public void setApplicationProtocols(List<String> applicationProtocols) {
        this.applicationProtocols = applicationProtocols;
    }

    @Schema(description="The type of component providing the listen port (e.g., Processor, ControllerService)")
    public String getComponentType() {
        return this.componentType;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    @Schema(description="The id of the component providing the listen port")
    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    @Schema(description="The name of the component providing the listen port")
    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    @Schema(description="The class type of the component providing the listen port")
    public String getComponentClass() {
        return this.componentClass;
    }

    public void setComponentClass(String componentClass) {
        this.componentClass = componentClass;
    }

    @Schema(description="The id of the process group containing the component providing the listen port, if applicable")
    public String getParentGroupId() {
        return this.parentGroupId;
    }

    public void setParentGroupId(String parentGroupId) {
        this.parentGroupId = parentGroupId;
    }

    @Schema(description="The name of the process group containing the component providing the listen port, if applicable")
    public String getParentGroupName() {
        return this.parentGroupName;
    }

    public void setParentGroupName(String parentGroupName) {
        this.parentGroupName = parentGroupName;
    }

    public String toString() {
        return "ListenPortDTO[portName= %s, portNumber=%s, transportProtocol=%s, applicationProtocols=%s, componentType=%s, componentId=%s, componentName=%s, componentClass=%s, parentGroupId=%s, parentGroupName=%s]".formatted(this.portName, this.portNumber, this.transportProtocol, this.applicationProtocols, this.componentType, this.componentId, this.componentName, this.componentClass, this.parentGroupId, this.parentGroupName);
    }
}

