/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.command;

import java.io.PrintStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.bootstrap.command.BootstrapCommand;
import org.apache.nifi.bootstrap.command.CommandStatus;
import org.apache.nifi.bootstrap.command.process.ManagementServerAddressProvider;
import org.apache.nifi.bootstrap.command.process.ProcessHandleProvider;
import org.apache.nifi.bootstrap.command.process.StandardManagementServerAddressProvider;
import org.apache.nifi.bootstrap.command.process.StandardProcessBuilderProvider;
import org.apache.nifi.bootstrap.configuration.ConfigurationProvider;
import org.apache.nifi.bootstrap.property.SecurityApplicationPropertyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GetRunCommandBootstrapCommand
implements BootstrapCommand {
    private static final String SPACE_SEPARATOR = " ";
    private static final Logger logger = LoggerFactory.getLogger(GetRunCommandBootstrapCommand.class);
    private final ConfigurationProvider configurationProvider;
    private final ProcessHandleProvider processHandleProvider;
    private final ManagementServerAddressProvider managementServerAddressProvider;
    private final PrintStream outputStream;
    private CommandStatus commandStatus = CommandStatus.ERROR;

    public GetRunCommandBootstrapCommand(ConfigurationProvider configurationProvider, ProcessHandleProvider processHandleProvider, PrintStream outputStream) {
        this.configurationProvider = Objects.requireNonNull(configurationProvider);
        this.processHandleProvider = Objects.requireNonNull(processHandleProvider);
        this.outputStream = Objects.requireNonNull(outputStream);
        this.managementServerAddressProvider = new StandardManagementServerAddressProvider(configurationProvider);
    }

    @Override
    public CommandStatus getCommandStatus() {
        return this.commandStatus;
    }

    @Override
    public void run() {
        try {
            Optional<ProcessHandle> applicationProcessHandle = this.processHandleProvider.findApplicationProcessHandle();
            if (applicationProcessHandle.isEmpty()) {
                SecurityApplicationPropertyHandler securityApplicationPropertyHandler = new SecurityApplicationPropertyHandler(logger);
                securityApplicationPropertyHandler.handleProperties(this.configurationProvider.getApplicationProperties());
                StandardProcessBuilderProvider processBuilderProvider = new StandardProcessBuilderProvider(this.configurationProvider, this.managementServerAddressProvider);
                ProcessBuilder processBuilder = processBuilderProvider.getApplicationProcessBuilder();
                List<String> command = processBuilder.command();
                String processCommand = String.join((CharSequence)SPACE_SEPARATOR, command);
                this.outputStream.println(processCommand);
                this.commandStatus = CommandStatus.SUCCESS;
            } else {
                logger.info("Application Process [{}] running", (Object)applicationProcessHandle.get().pid());
                this.commandStatus = CommandStatus.ERROR;
            }
        }
        catch (Throwable e) {
            logger.warn("Application Process command building failed", e);
            this.commandStatus = CommandStatus.FAILED;
        }
    }
}

