/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RenditionDataImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Content;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Folder;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.ContentStreamDataImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.ImageThumbnailGenerator;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.StoredObjectImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenditionUtil {
    private static final Logger LOG = LoggerFactory.getLogger((String)RenditionUtil.class.getName());
    private static final int BUFFER_SIZE = 65536;
    public static final String RENDITION_MIME_TYPE_JPEG = "image/jpeg";
    public static final String RENDITION_MIME_TYPE_PNG = "image/png";
    public static final String RENDITION_SUFFIX = "-rendition";
    public static final int THUMBNAIL_SIZE = 100;
    public static final int ICON_SIZE = 32;

    public static boolean hasRendition(StoredObject so, String user) {
        if (so instanceof Folder) {
            return true;
        }
        if (so instanceof Content) {
            ContentStream contentStream = ((Content)((Object)so)).getContent();
            if (null == contentStream) {
                return false;
            }
            String mimeType = contentStream.getMimeType();
            return RenditionUtil.isImage(mimeType) || RenditionUtil.isAudio(mimeType) || RenditionUtil.isVideo(mimeType) || RenditionUtil.isPDF(mimeType) || RenditionUtil.isPowerpoint(mimeType) || RenditionUtil.isExcel(mimeType) || RenditionUtil.isWord(mimeType) || RenditionUtil.isHtml(mimeType) || RenditionUtil.isPlainText(mimeType);
        }
        return false;
    }

    private static boolean isImage(String mimeType) {
        return mimeType.startsWith("image/");
    }

    private static boolean isWord(String mimeType) {
        return mimeType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document") || mimeType.equals("application/ms-word");
    }

    private static boolean isExcel(String mimeType) {
        return mimeType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet") || mimeType.equals("application/vnd.ms-excel");
    }

    private static boolean isPowerpoint(String mimeType) {
        return mimeType.equals("application/vnd.openxmlformats-officedocument.presentationml.slideshow") || mimeType.equals("application/vnd.openxmlformats-officedocument.presentationml.presentation") || mimeType.equals("application/vnd.ms-powerpoint");
    }

    private static boolean isPDF(String mimeType) {
        return mimeType.equals("application/pdf");
    }

    private static boolean isHtml(String mimeType) {
        return mimeType.equals("text/html");
    }

    private static boolean isAudio(String mimeType) {
        return mimeType.startsWith("audio/");
    }

    private static boolean isVideo(String mimeType) {
        return mimeType.startsWith("video/");
    }

    private static boolean isPlainText(String mimeType) {
        return mimeType.equals("text/plain");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentStream getIconFromResourceDir(String name) throws IOException {
        InputStream imageStream = StoredObjectImpl.class.getResourceAsStream(name);
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        byte[] buffer = new byte[65536];
        int noBytesRead = 0;
        try {
            while ((noBytesRead = imageStream.read(buffer)) >= 0) {
                ba.write(buffer, 0, noBytesRead);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)ba);
            IOUtils.closeQuietly((Closeable)imageStream);
        }
        ContentStreamDataImpl content = new ContentStreamDataImpl(0L);
        content.setFileName(name);
        content.setMimeType(RENDITION_MIME_TYPE_PNG);
        content.setContent(new ByteArrayInputStream(ba.toByteArray()));
        return content;
    }

    public static boolean testRenditionFilterForImage(String[] formats) {
        if (formats.length == 1 && null != formats[0] && formats[0].equals("cmis:none")) {
            return false;
        }
        return RenditionUtil.arrayContainsString(formats, "*") || RenditionUtil.arrayContainsString(formats, "image/*") || RenditionUtil.arrayContainsString(formats, RENDITION_MIME_TYPE_JPEG);
    }

    private static boolean arrayContainsString(String[] formats, String val) {
        for (String s : formats) {
            if (!val.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static ContentStream getRenditionContent(StoredObject so, String streamId, long offset, long length) {
        if (so instanceof Folder) {
            return RenditionUtil.getFolderRenditionContent(streamId, offset, length);
        }
        if (!(so instanceof Content)) {
            throw new CmisInvalidArgumentException("Only objects with content can have a rendition");
        }
        ContentStream contentStream = ((Content)((Object)so)).getContent();
        if (null == contentStream) {
            return null;
        }
        String mimeType = contentStream.getMimeType();
        try {
            if (RenditionUtil.isImage(mimeType)) {
                ImageThumbnailGenerator generator = new ImageThumbnailGenerator(contentStream.getStream());
                return generator.getRendition(100, 0);
            }
            if (RenditionUtil.isAudio(mimeType)) {
                return RenditionUtil.getIconFromResourceDir("/audio-x-generic.png");
            }
            if (RenditionUtil.isVideo(mimeType)) {
                return RenditionUtil.getIconFromResourceDir("/video-x-generic.png");
            }
            if (RenditionUtil.isPDF(mimeType)) {
                return RenditionUtil.getIconFromResourceDir("/application-pdf.png");
            }
            if (RenditionUtil.isWord(mimeType)) {
                return RenditionUtil.getIconFromResourceDir("/application-msword.png");
            }
            if (RenditionUtil.isPowerpoint(mimeType)) {
                return RenditionUtil.getIconFromResourceDir("/application-vnd.ms-powerpoint.png");
            }
            if (RenditionUtil.isExcel(mimeType)) {
                return RenditionUtil.getIconFromResourceDir("/application-vnd.ms-excel.png");
            }
            if (RenditionUtil.isHtml(mimeType)) {
                return RenditionUtil.getIconFromResourceDir("/text-html.png");
            }
            if (RenditionUtil.isPlainText(mimeType)) {
                return RenditionUtil.getIconFromResourceDir("/text-x-generic.png");
            }
            return null;
        }
        catch (IOException e) {
            LOG.error("Failed to generate rendition: ", (Throwable)e);
            throw new CmisRuntimeException("Failed to generate rendition: " + e);
        }
    }

    private static ContentStream getFolderRenditionContent(String streamId, long offset, long length) {
        try {
            return RenditionUtil.getIconFromResourceDir("/folder.png");
        }
        catch (IOException e) {
            LOG.error("Failed to generate rendition: ", (Throwable)e);
            throw new CmisRuntimeException("Failed to generate rendition: " + e);
        }
    }

    public static List<RenditionData> getRenditions(StoredObject so, String renditionFilter, long maxItems, long skipCount) {
        String tokenizer = "[\\s;]";
        if (null == renditionFilter) {
            return null;
        }
        String[] formats = renditionFilter.split(tokenizer);
        boolean isImageRendition = RenditionUtil.testRenditionFilterForImage(formats);
        if (!(so instanceof Content) && !(so instanceof Folder)) {
            return null;
        }
        if (isImageRendition && RenditionUtil.hasRendition(so, null)) {
            String mimeType;
            if (so instanceof Folder) {
                mimeType = RENDITION_MIME_TYPE_PNG;
            } else {
                ContentStream contentStream = ((Content)((Object)so)).getContent();
                mimeType = contentStream.getMimeType();
            }
            ArrayList<RenditionData> renditions = new ArrayList<RenditionData>(1);
            RenditionDataImpl rendition = new RenditionDataImpl();
            if (mimeType.equals(RENDITION_MIME_TYPE_JPEG)) {
                rendition.setBigHeight(BigInteger.valueOf(100L));
                rendition.setBigWidth(BigInteger.valueOf(100L));
                rendition.setMimeType(RENDITION_MIME_TYPE_JPEG);
            } else {
                rendition.setBigHeight(BigInteger.valueOf(32L));
                rendition.setBigWidth(BigInteger.valueOf(32L));
                rendition.setMimeType(RENDITION_MIME_TYPE_PNG);
            }
            rendition.setKind("cmis:thumbnail");
            rendition.setRenditionDocumentId(so.getId());
            rendition.setStreamId(so.getId() + RENDITION_SUFFIX);
            rendition.setBigLength(BigInteger.valueOf(-1L));
            rendition.setTitle(so.getName());
            renditions.add((RenditionData)rendition);
            return renditions;
        }
        return null;
    }
}

