/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Objects;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.DefaultAttributeType;

final class SingletonAttribute<V>
extends AbstractAttribute<V>
implements Cloneable {
    private static final long serialVersionUID = -2236273725166545505L;
    private V value;

    public SingletonAttribute(DefaultAttributeType<V> defaultAttributeType) {
        super(defaultAttributeType);
        assert (SingletonAttribute.isSingleton(defaultAttributeType.getMaximumOccurs()));
        this.value = defaultAttributeType.getDefaultValue();
    }

    SingletonAttribute(DefaultAttributeType<V> defaultAttributeType, Object object) {
        super(defaultAttributeType);
        assert (SingletonAttribute.isSingleton(defaultAttributeType.getMaximumOccurs()));
        this.value = defaultAttributeType.getValueClass().cast(object);
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public void setValue(V v) {
        this.value = v;
    }

    public int hashCode() {
        return this.type.hashCode() + Objects.hashCode(this.value) + this.characteristicsReadOnly().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SingletonAttribute) {
            SingletonAttribute singletonAttribute = (SingletonAttribute)object;
            return this.type.equals(singletonAttribute.type) && Objects.equals(this.value, singletonAttribute.value) && this.characteristicsReadOnly().equals(singletonAttribute.characteristicsReadOnly());
        }
        return false;
    }
}

