/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.storage;

import com.google.common.io.CountingOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.storage.FileMetadata;
import org.apache.spark.sql.delta.storage.HadoopFileSystemLogStore;
import org.apache.spark.sql.delta.storage.S3SingleDriverLogStore$;
import org.apache.spark.sql.delta.util.FileNames$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001\u0002\u0010 \u00011B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!)q\b\u0001C\u0001\u0001\")A\t\u0001C\u0005\u000b\")\u0001\f\u0001C\u00053\")A\f\u0001C\u0005;\")q\f\u0001C\u0005A\")A\u000f\u0001C\u0005k\")Q\u0010\u0001C\u0005}\"I\u0011Q\u0002\u0001\u0012\u0002\u0013%\u0011q\u0002\u0005\b\u0003K\u0001A\u0011IA\u0014\u0011\u001d\t)\u0003\u0001C!\u0003WAq!!\r\u0001\t\u0013\t\u0019\u0004C\u0004\u00028\u0001!I!!\u000f\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B!I\u0011Q\r\u0001\u0012\u0002\u0013\u0005\u0011q\u0002\u0005\b\u0003\u007f\u0001A\u0011IA4\u0011\u001d\t\t\b\u0001C!\u0003gBq!!\u001d\u0001\t\u0003\n9\bC\u0004\u0002~\u0001!\t%a \b\u000f\u0005\u0005u\u0004#\u0001\u0002\u0004\u001a1ad\bE\u0001\u0003\u000bCaa\u0010\f\u0005\u0002\u00055\u0005\"CAH-\t\u0007I\u0011BAI\u0011!\t9K\u0006Q\u0001\n\u0005M\u0005\"CAU-\t\u0007I\u0011BAV\u0011!\tYM\u0006Q\u0001\n\u00055\u0006bBAg-\u0011%\u0011q\u001a\u0005\b\u0003'4B\u0011BAk\u0005Y\u00196gU5oO2,GI]5wKJdunZ*u_J,'B\u0001\u0011\"\u0003\u001d\u0019Ho\u001c:bO\u0016T!AI\u0012\u0002\u000b\u0011,G\u000e^1\u000b\u0005\u0011*\u0013aA:rY*\u0011aeJ\u0001\u0006gB\f'o\u001b\u0006\u0003Q%\na!\u00199bG\",'\"\u0001\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001i\u0003C\u0001\u00180\u001b\u0005y\u0012B\u0001\u0019 \u0005aA\u0015\rZ8pa\u001aKG.Z*zgR,W\u000eT8h'R|'/Z\u0001\ngB\f'o[\"p]\u001a\u0004\"a\r\u001b\u000e\u0003\u0015J!!N\u0013\u0003\u0013M\u0003\u0018M]6D_:4\u0017A\u00035bI>|\u0007oQ8oMB\u0011\u0001(P\u0007\u0002s)\u0011!hO\u0001\u0005G>tgM\u0003\u0002=O\u00051\u0001.\u00193p_BL!AP\u001d\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q\u0019\u0011IQ\"\u0011\u00059\u0002\u0001\"B\u0019\u0004\u0001\u0004\u0011\u0004\"\u0002\u001c\u0004\u0001\u00049\u0014\u0001\u0003:fg>dg/\u001a3\u0015\u0007\u0019+v\u000b\u0005\u0003H\u00152\u0013V\"\u0001%\u000b\u0003%\u000bQa]2bY\u0006L!a\u0013%\u0003\rQ+\b\u000f\\33!\ti\u0005+D\u0001O\u0015\ty5(\u0001\u0002gg&\u0011\u0011K\u0014\u0002\u000b\r&dWmU=ti\u0016l\u0007CA'T\u0013\t!fJ\u0001\u0003QCRD\u0007\"\u0002,\u0005\u0001\u0004\u0011\u0016\u0001\u00029bi\"DQA\u000e\u0003A\u0002]\n!bZ3u!\u0006$\bnS3z)\t\u0011&\fC\u0003\\\u000b\u0001\u0007!+\u0001\u0007sKN|GN^3e!\u0006$\b.A\u0007tiJL\u0007/V:fe&sgm\u001c\u000b\u0003%zCQA\u0016\u0004A\u0002I\u000b!#\\3sO\u00164\u0015\u000e\\3Ji\u0016\u0014\u0018\r^8sgR\u0019\u0011\r\u001d:\u0011\u0007\tTWN\u0004\u0002dQ:\u0011AmZ\u0007\u0002K*\u0011amK\u0001\u0007yI|w\u000e\u001e \n\u0003%K!!\u001b%\u0002\u000fA\f7m[1hK&\u00111\u000e\u001c\u0002\t\u0013R,'/\u0019;pe*\u0011\u0011\u000e\u0013\t\u0003\u001b:L!a\u001c(\u0003\u0015\u0019KG.Z*uCR,8\u000fC\u0003r\u000f\u0001\u0007\u0011-\u0001\u0003ji\u0016\u0014\b\"B:\b\u0001\u0004\t\u0017AE5uKJ<\u0016\u000e\u001e5Qe\u0016\u001cW\rZ3oG\u0016\fQ\u0002\\5ti\u001a\u0013x.\\\"bG\",Gc\u0001<|yB\u0019qO_7\u000e\u0003aT!!\u001f%\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002lq\")q\n\u0003a\u0001\u0019\")1\f\u0003a\u0001%\u0006\u0001B.[:u\rJ|W.\u00138uKJt\u0017\r\u001c\u000b\u0007C~\f\t!a\u0001\t\u000b=K\u0001\u0019\u0001'\t\u000bmK\u0001\u0019\u0001*\t\u0013\u0005\u0015\u0011\u0002%AA\u0002\u0005\u001d\u0011\u0001C;tK\u000e\u000b7\r[3\u0011\u0007\u001d\u000bI!C\u0002\u0002\f!\u0013qAQ8pY\u0016\fg.\u0001\u000emSN$hI]8n\u0013:$XM\u001d8bY\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0012)\"\u0011qAA\nW\t\t)\u0002\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0010\u0011\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0012\u0011\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\u00037jgR4%o\\7\u0015\u0007\u0005\fI\u0003C\u0003W\u0017\u0001\u0007!\u000bF\u0003b\u0003[\ty\u0003C\u0003W\u0019\u0001\u0007!\u000bC\u00037\u0019\u0001\u0007q'\u0001\tjg&s\u0017\u000e^5bYZ+'o]5p]R!\u0011qAA\u001b\u0011\u00151V\u00021\u0001S\u0003\u0019)\u00070[:ugR1\u0011qAA\u001e\u0003{AQa\u0014\bA\u00021CQa\u0017\bA\u0002I\u000bQa\u001e:ji\u0016$\u0002\"a\u0011\u0002J\u0005-\u0013\u0011\r\t\u0004\u000f\u0006\u0015\u0013bAA$\u0011\n!QK\\5u\u0011\u00151v\u00021\u0001S\u0011\u001d\tie\u0004a\u0001\u0003\u001f\nq!Y2uS>t7\u000f\u0005\u0003cU\u0006E\u0003\u0003BA*\u00037rA!!\u0016\u0002XA\u0011A\rS\u0005\u0004\u00033B\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002^\u0005}#AB*ue&twMC\u0002\u0002Z!C\u0011\"a\u0019\u0010!\u0003\u0005\r!a\u0002\u0002\u0013=4XM]<sSR,\u0017aD<sSR,G\u0005Z3gCVdG\u000fJ\u001a\u0015\u0015\u0005\r\u0013\u0011NA6\u0003[\ny\u0007C\u0003W#\u0001\u0007!\u000bC\u0004\u0002NE\u0001\r!a\u0014\t\u000f\u0005\r\u0014\u00031\u0001\u0002\b!)a'\u0005a\u0001o\u0005)\u0012n\u001d)beRL\u0017\r\\,sSR,g+[:jE2,G\u0003BA\u0004\u0003kBQA\u0016\nA\u0002I#b!a\u0002\u0002z\u0005m\u0004\"\u0002,\u0014\u0001\u0004\u0011\u0006\"\u0002\u001c\u0014\u0001\u00049\u0014aD5om\u0006d\u0017\u000eZ1uK\u000e\u000b7\r[3\u0015\u0005\u0005\r\u0013AF*4'&tw\r\\3Ee&4XM\u001d'pON#xN]3\u0011\u0005922c\u0001\f\u0002\bB\u0019q)!#\n\u0007\u0005-\u0005J\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003\u0007\u000b\u0001\u0002]1uQ2{7m[\u000b\u0003\u0003'\u0003r!!&\u0002$J\u000b9)\u0004\u0002\u0002\u0018*!\u0011\u0011TAN\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003;\u000by*\u0001\u0003vi&d'BAAQ\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u0016q\u0013\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\u0018!\u00039bi\"dunY6!\u0003A9(/\u001b;uK:\u0004\u0016\r\u001e5DC\u000eDW-\u0006\u0002\u0002.B9\u0011qVAa%\u0006\u0015WBAAY\u0015\u0011\t\u0019,!.\u0002\u000b\r\f7\r[3\u000b\t\u0005]\u0016\u0011X\u0001\u0007G>lWn\u001c8\u000b\t\u0005m\u0016QX\u0001\u0007O>|w\r\\3\u000b\u0005\u0005}\u0016aA2p[&!\u00111YAY\u0005\u0015\u0019\u0015m\u00195f!\rq\u0013qY\u0005\u0004\u0003\u0013|\"\u0001\u0004$jY\u0016lU\r^1eCR\f\u0017!E<sSR$XM\u001c)bi\"\u001c\u0015m\u00195fA\u0005y!/\u001a7fCN,\u0007+\u0019;i\u0019>\u001c7\u000e\u0006\u0003\u0002D\u0005E\u0007\"B.\u001d\u0001\u0004\u0011\u0016aD1dcVL'/\u001a)bi\"dunY6\u0015\t\u0005\r\u0013q\u001b\u0005\u00067v\u0001\rA\u0015")
public class S3SingleDriverLogStore
extends HadoopFileSystemLogStore {
    private Tuple2<FileSystem, Path> resolved(Path path, Configuration hadoopConf) {
        FileSystem fs = path.getFileSystem(hadoopConf);
        Path resolvedPath = this.stripUserInfo(fs.makeQualified(path));
        return new Tuple2((Object)fs, (Object)resolvedPath);
    }

    private Path getPathKey(Path resolvedPath) {
        return this.stripUserInfo(resolvedPath);
    }

    private Path stripUserInfo(Path path) {
        URI uri = path.toUri();
        URI newUri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        return new Path(newUri);
    }

    private Iterator<FileStatus> mergeFileIterators(Iterator<FileStatus> iter, Iterator<FileStatus> iterWithPrecedence) {
        return ((IterableLike)iter.map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.getPath(), f)).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)iterWithPrecedence.map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.getPath(), f))).values().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath().getName(), (Ordering)Ordering.String$.MODULE$)).iterator();
    }

    private Iterator<FileStatus> listFromCache(FileSystem fs, Path resolvedPath) {
        Path pathKey = this.getPathKey(resolvedPath);
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$writtenPathCache().asMap()).asScala()).iterator().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)S3SingleDriverLogStore.$anonfun$listFromCache$1(pathKey, x0$1))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path path = (Path)tuple2._1();
            FileMetadata fileMetadata = (FileMetadata)tuple2._2();
            FileStatus fileStatus = new FileStatus(fileMetadata.length(), false, 1, fs.getDefaultBlockSize(path), fileMetadata.modificationTime(), path);
            return fileStatus;
        });
    }

    private Iterator<FileStatus> listFromInternal(FileSystem fs, Path resolvedPath, boolean useCache) {
        Path parentPath = resolvedPath.getParent();
        if (!fs.exists(parentPath)) {
            throw DeltaErrors$.MODULE$.fileOrDirectoryNotFoundException(parentPath.toString());
        }
        Iterator listedFromFs = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(parentPath))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)S3SingleDriverLogStore.$anonfun$listFromInternal$1(resolvedPath, x$2))))).iterator();
        Iterator<FileStatus> listedFromCache = useCache ? this.listFromCache(fs, resolvedPath) : package$.MODULE$.Iterator().empty();
        return this.mergeFileIterators(listedFromCache, (Iterator<FileStatus>)listedFromFs);
    }

    @Override
    public Iterator<FileStatus> listFrom(Path path) {
        return this.listFrom(path, this.getHadoopConfiguration());
    }

    @Override
    public Iterator<FileStatus> listFrom(Path path, Configuration hadoopConf) {
        Tuple2<FileSystem, Path> tuple2 = this.resolved(path, hadoopConf);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        FileSystem fs = (FileSystem)tuple2._1();
        Path resolvedPath = (Path)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fs, (Object)resolvedPath);
        Tuple2 tuple23 = tuple22;
        FileSystem fs2 = (FileSystem)tuple23._1();
        Path resolvedPath2 = (Path)tuple23._2();
        return this.listFromInternal(fs2, resolvedPath2, this.listFromInternal$default$3());
    }

    private boolean listFromInternal$default$3() {
        return true;
    }

    private boolean isInitialVersion(Path path) {
        return FileNames$.MODULE$.isDeltaFile(path) && FileNames$.MODULE$.deltaVersion(path) == 0L;
    }

    private boolean exists(FileSystem fs, Path resolvedPath) {
        return this.listFromInternal(fs, resolvedPath, !this.isInitialVersion(resolvedPath)).take(1).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)S3SingleDriverLogStore.$anonfun$exists$1(resolvedPath, x$4)));
    }

    @Override
    public void write(Path path, Iterator<String> actions, boolean overwrite) {
        this.write(path, actions, overwrite, this.getHadoopConfiguration());
    }

    @Override
    public void write(Path path, Iterator<String> actions, boolean overwrite, Configuration hadoopConf) {
        Tuple2<FileSystem, Path> tuple2 = this.resolved(path, hadoopConf);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        FileSystem fs = (FileSystem)tuple2._1();
        Path resolvedPath = (Path)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fs, (Object)resolvedPath);
        Tuple2 tuple23 = tuple22;
        FileSystem fs2 = (FileSystem)tuple23._1();
        Path resolvedPath2 = (Path)tuple23._2();
        Path lockedPath = this.getPathKey(resolvedPath2);
        S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$acquirePathLock(lockedPath);
        try {
            try {
                if (this.exists(fs2, resolvedPath2) && !overwrite) {
                    throw new java.nio.file.FileAlreadyExistsException(resolvedPath2.toUri().toString());
                }
                CountingOutputStream stream = new CountingOutputStream((OutputStream)fs2.create(resolvedPath2, overwrite));
                actions.map((Function1 & Serializable & scala.Serializable)x$6 -> new StringBuilder(1).append((String)x$6).append("\n").toString()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getBytes(StandardCharsets.UTF_8)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    stream.write(x$1);
                    return BoxedUnit.UNIT;
                });
                stream.close();
                if (this.isInitialVersion(resolvedPath2)) {
                    java.lang.Iterable obsoleteFiles = (java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$writtenPathCache().asMap()).asScala()).keys().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)S3SingleDriverLogStore.$anonfun$write$4(lockedPath, x$8)))).asJava();
                    S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$writtenPathCache().invalidateAll(obsoleteFiles);
                }
                S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$writtenPathCache().put((Object)lockedPath, (Object)new FileMetadata(stream.getCount(), System.currentTimeMillis()));
            }
            catch (FileAlreadyExistsException e) {
                throw new java.nio.file.FileAlreadyExistsException(e.getMessage());
            }
        }
        finally {
            S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$releasePathLock(lockedPath);
        }
    }

    @Override
    public boolean write$default$3() {
        return false;
    }

    @Override
    public boolean isPartialWriteVisible(Path path) {
        return false;
    }

    @Override
    public boolean isPartialWriteVisible(Path path, Configuration hadoopConf) {
        return false;
    }

    @Override
    public void invalidateCache() {
        S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$writtenPathCache().invalidateAll();
    }

    public static final /* synthetic */ boolean $anonfun$listFromCache$1(Path pathKey$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Path path = (Path)tuple2._1();
        Path path2 = path.getParent();
        Path path3 = pathKey$1.getParent();
        boolean bl = !(path2 != null ? !path2.equals(path3) : path3 != null) && new StringOps(Predef$.MODULE$.augmentString(path.getName())).$greater$eq((Object)pathKey$1.getName());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$listFromInternal$1(Path resolvedPath$1, FileStatus x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2.getPath().getName())).$greater$eq((Object)resolvedPath$1.getName());
    }

    public static final /* synthetic */ boolean $anonfun$exists$1(Path resolvedPath$2, FileStatus x$4) {
        String string = x$4.getPath().getName();
        String string2 = resolvedPath$2.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$write$4(Path lockedPath$1, Path x$8) {
        Path path = x$8.getParent();
        Path path2 = lockedPath$1.getParent();
        return !(path != null ? !path.equals(path2) : path2 != null);
    }

    public S3SingleDriverLogStore(SparkConf sparkConf, Configuration hadoopConf) {
        super(sparkConf, hadoopConf);
    }
}

