/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.constraints;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.ArrayForAll;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction$;
import org.apache.spark.sql.catalyst.expressions.Length;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MapKeys;
import org.apache.spark.sql.catalyst.expressions.MapValues;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable$;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.delta.constraints.Constraint;
import org.apache.spark.sql.delta.constraints.Constraints;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.VarcharType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class CharVarcharConstraint$ {
    public static CharVarcharConstraint$ MODULE$;

    static {
        new CharVarcharConstraint$();
    }

    public final String INVARIANT_NAME() {
        return "__CHAR_VARCHAR_STRING_LENGTH_CHECK__";
    }

    public Seq<Constraint> stringConstraints(StructType schema) {
        return (Seq)schema.flatMap((Function1 & Serializable & scala.Serializable)f -> {
            DataType targetType = (DataType)CharVarcharUtils$.MODULE$.getRawType(f.metadata()).getOrElse((Function0 & Serializable & scala.Serializable)() -> f.dataType());
            UnresolvedAttribute col = new UnresolvedAttribute((Seq)new .colon.colon((Object)f.name(), (List)Nil$.MODULE$));
            return Option$.MODULE$.option2Iterable(MODULE$.checkStringLength((Expression)col, targetType).map((Function1 & Serializable & scala.Serializable)lengthCheckExpr -> new Constraints.Check("__CHAR_VARCHAR_STRING_LENGTH_CHECK__", (Expression)lengthCheckExpr)));
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Option<Expression> checkStringLength(Expression expr, DataType dt) {
        Some some;
        block8: {
            DataType dataType;
            while (true) {
                if ((dataType = dt) instanceof VarcharType) {
                    VarcharType varcharType = (VarcharType)dataType;
                    int length = varcharType.length();
                    some = new Some((Object)new Or((Expression)new IsNull(expr), (Expression)new LessThanOrEqual((Expression)new Length(expr), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)length)))));
                    break block8;
                }
                if (!(dataType instanceof CharType)) break;
                CharType charType = (CharType)dataType;
                int length = charType.length();
                dt = new VarcharType(length);
            }
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fields = structType.fields();
                some = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    StructField f = (StructField)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Iterable iterable = Option$.MODULE$.option2Iterable(MODULE$.checkStringLength((Expression)new GetStructField(expr, i, (Option)new Some((Object)f.name())), f.dataType()));
                    return iterable;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class))))).reduceOption((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> new And(x$1, x$2));
            } else if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType et = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                some = this.checkStringLengthInArray(expr, et, containsNull);
            } else if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType kt = mapType.keyType();
                DataType vt = mapType.valueType();
                boolean valueContainsNull = mapType.valueContainsNull();
                some = ((TraversableOnce)Option$.MODULE$.option2Iterable(this.checkStringLengthInArray((Expression)new MapKeys(expr), kt, false)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.checkStringLengthInArray((Expression)new MapValues(expr), vt, valueContainsNull)), Iterable$.MODULE$.canBuildFrom())).reduceOption((Function2 & Serializable & scala.Serializable)(x$3, x$4) -> new And(x$3, x$4));
            } else {
                some = None$.MODULE$;
            }
        }
        return some;
    }

    private Option<Expression> checkStringLengthInArray(Expression arr, DataType et, boolean containsNull) {
        DataType cleanedType = CharVarcharUtils$.MODULE$.replaceCharVarcharWithString(et);
        NamedLambdaVariable param = new NamedLambdaVariable("x", cleanedType, containsNull, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        return this.checkStringLength((Expression)param, et).map((Function1 & Serializable & scala.Serializable)checkExpr -> new Or((Expression)new IsNull(arr), (Expression)new ArrayForAll(arr, (Expression)new LambdaFunction(checkExpr, (Seq)new .colon.colon((Object)param, (List)Nil$.MODULE$), LambdaFunction$.MODULE$.apply$default$3()))));
    }

    private CharVarcharConstraint$() {
        MODULE$ = this;
    }
}

