/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.LogSegment;
import org.apache.spark.util.ThreadUtils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;

public final class SnapshotManagement$ {
    public static SnapshotManagement$ MODULE$;
    private ExecutionContextExecutorService deltaLogAsyncUpdateThreadPool;
    private volatile boolean bitmap$0;

    static {
        new SnapshotManagement$();
    }

    private ExecutionContextExecutorService deltaLogAsyncUpdateThreadPool$lzycompute() {
        SnapshotManagement$ snapshotManagement$ = this;
        synchronized (snapshotManagement$) {
            if (!this.bitmap$0) {
                ThreadPoolExecutor tpe = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("delta-state-update", 8, ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
                this.deltaLogAsyncUpdateThreadPool = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)tpe);
                this.bitmap$0 = true;
            }
        }
        return this.deltaLogAsyncUpdateThreadPool;
    }

    public ExecutionContextExecutorService deltaLogAsyncUpdateThreadPool() {
        return !this.bitmap$0 ? this.deltaLogAsyncUpdateThreadPool$lzycompute() : this.deltaLogAsyncUpdateThreadPool;
    }

    public void verifyDeltaVersions(SparkSession spark, long[] versions, Option<Object> expectedStartVersion, Option<Object> expectedEndVersion) {
        if (new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(versions)).nonEmpty()) {
            Vector deltaVersions = new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(versions)).toVector();
            NumericRange.Inclusive inclusive = new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)deltaVersions.head()))).to(deltaVersions.last());
            Vector vector = deltaVersions;
            if (inclusive == null ? vector != null : !inclusive.equals(vector)) {
                throw DeltaErrors$.MODULE$.deltaVersionsNotContiguousException(spark, (Seq<Object>)deltaVersions);
            }
        }
        expectedStartVersion.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)v -> Predef$.MODULE$.require(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(versions)).nonEmpty() && BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(versions)).head()) == v, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Did not get the first delta ").append("file version: ").append(v).append(" to compute Snapshot").toString()));
        expectedEndVersion.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)v -> Predef$.MODULE$.require(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(versions)).nonEmpty() && BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(versions)).last()) == v, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Did not get the first delta ").append("file version: ").append(v).append(" to compute Snapshot").toString()));
    }

    public LogSegment appendCommitToLogSegment(LogSegment oldLogSegment, FileStatus commitFileStatus, long committedVersion) {
        Predef$.MODULE$.require(oldLogSegment.version() + 1L == committedVersion);
        long x$1 = committedVersion;
        Seq x$2 = (Seq)oldLogSegment.deltas().$colon$plus((Object)commitFileStatus, Seq$.MODULE$.canBuildFrom());
        long x$3 = commitFileStatus.getModificationTime();
        Path x$4 = oldLogSegment.copy$default$1();
        Seq<FileStatus> x$5 = oldLogSegment.copy$default$4();
        Option<Object> x$6 = oldLogSegment.copy$default$5();
        return oldLogSegment.copy(x$4, x$1, (Seq<FileStatus>)x$2, x$5, x$6, x$3);
    }

    private SnapshotManagement$() {
        MODULE$ = this;
    }
}

