/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.dao;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.dao.JobStatistics;
import org.apache.kylin.job.dao.JobStatisticsBasic;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;

public class JobStatisticsManager {
    private KylinConfig config;
    private String project;
    private CachedCrudAssist<JobStatistics> crud;

    public static JobStatisticsManager getInstance(KylinConfig config, String project) {
        return (JobStatisticsManager)config.getManager(project, JobStatisticsManager.class);
    }

    static JobStatisticsManager newInstance(KylinConfig conf, String project) {
        try {
            String cls = JobStatisticsManager.class.getName();
            Class clz = ClassUtil.forName((String)cls, JobStatisticsManager.class);
            return (JobStatisticsManager)clz.getConstructor(KylinConfig.class, String.class).newInstance(conf, project);
        }
        catch (Exception e) {
            throw new KylinRuntimeException("Failed to init DataModelManager from " + conf, (Throwable)e);
        }
    }

    public JobStatisticsManager(KylinConfig config, String project) {
        this.init(config, project);
    }

    protected void init(KylinConfig cfg, String project) {
        this.config = cfg;
        this.project = project;
        ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)this.config);
        this.crud = new CachedCrudAssist<JobStatistics>(store, MetadataType.JOB_STATS, project, JobStatistics.class){

            protected JobStatistics initEntityAfterReload(JobStatistics jobStatistics, String resourceName) {
                return jobStatistics;
            }
        };
    }

    public List<JobStatistics> getAll() {
        return this.crud.listAll();
    }

    public JobStatistics copyForWrite(JobStatistics jobStatistics) {
        if (jobStatistics.getProject() == null) {
            jobStatistics.setProject(this.project);
        }
        return (JobStatistics)this.crud.copyForWrite((RootPersistentEntity)jobStatistics);
    }

    public JobStatistics get(long date) {
        return (JobStatistics)this.crud.get(JobStatistics.generateResourceName(this.project, date));
    }

    public JobStatistics updateStatistics(long date, String model, long duration, long byteSize, int deltaCount) {
        JobStatistics jobStatistics = this.get(date);
        if (jobStatistics == null && (jobStatistics = this.copyForWrite(new JobStatistics(date, model, duration, byteSize))).getMvcc() == -1L) {
            return (JobStatistics)this.crud.save((RootPersistentEntity)jobStatistics);
        }
        JobStatistics jobStatisticsToUpdate = this.copyForWrite(jobStatistics);
        jobStatisticsToUpdate.update(model, duration, byteSize, deltaCount);
        return (JobStatistics)this.crud.save((RootPersistentEntity)jobStatisticsToUpdate);
    }

    public JobStatistics updateStatistics(long date, long duration, long byteSize, int deltaCount) {
        JobStatistics jobStatistics = this.get(date);
        if (jobStatistics == null) {
            jobStatistics = this.copyForWrite(new JobStatistics(date, duration, byteSize));
            return (JobStatistics)this.crud.save((RootPersistentEntity)jobStatistics);
        }
        JobStatistics jobStatisticsToUpdate = this.copyForWrite(jobStatistics);
        jobStatisticsToUpdate.update(duration, byteSize, deltaCount);
        return (JobStatistics)this.crud.save((RootPersistentEntity)jobStatisticsToUpdate);
    }

    public Pair<Integer, JobStatistics> getOverallJobStats(long startTime, long endTime) {
        List<JobStatistics> filteredJobStats = this.getFilteredJobStatsByTime(startTime, endTime);
        JobStatistics aggregatedStats = this.aggregateJobStats(filteredJobStats);
        return new Pair((Object)aggregatedStats.getCount(), (Object)aggregatedStats);
    }

    public Map<String, Integer> getJobCountByTime(long startTime, long endTime, String timeDimension) {
        HashMap result = Maps.newHashMap();
        this.aggregateJobStatsByTime(startTime, endTime, timeDimension).forEach((key, value) -> result.put(key, value.getCount()));
        return result;
    }

    public Map<String, Integer> getJobCountByModel(long startTime, long endTime) {
        HashMap result = Maps.newHashMap();
        this.aggregateStatsByModel(startTime, endTime).forEach((modelName, value) -> {
            String modelAlias = this.getModelAlias((String)modelName);
            if (modelAlias == null) {
                return;
            }
            result.put(modelAlias, value.getCount());
        });
        return result;
    }

    public Map<String, Double> getDurationPerByteByTime(long startTime, long endTime, String timeDimension) {
        Map<String, JobStatisticsBasic> aggregateResult = this.aggregateJobStatsByTime(startTime, endTime, timeDimension);
        return this.calculateDurationPerByte(aggregateResult);
    }

    public Map<String, Double> getDurationPerByteByModel(long startTime, long endTime) {
        HashMap transformedResult = Maps.newHashMap();
        this.aggregateStatsByModel(startTime, endTime).forEach((modelName, value) -> {
            String modelAlias = this.getModelAlias((String)modelName);
            if (modelAlias == null) {
                return;
            }
            transformedResult.put(modelAlias, new JobStatisticsBasic(value.getTotalDuration(), value.getTotalByteSize()));
        });
        return this.calculateDurationPerByte(transformedResult);
    }

    private String getModelAlias(String modelId) {
        NDataModelManager dataModelManager = NDataModelManager.getInstance((KylinConfig)this.config, (String)this.project);
        NDataModel model = dataModelManager.getDataModelDesc(modelId);
        if (model == null) {
            return null;
        }
        return model.getAlias();
    }

    private JobStatistics aggregateJobStats(List<JobStatistics> jobStatisticsToAggregate) {
        return jobStatisticsToAggregate.stream().reduce((x, y) -> new JobStatistics(x.getCount() + y.getCount(), x.getTotalDuration() + y.getTotalDuration(), x.getTotalByteSize() + y.getTotalByteSize())).orElse(new JobStatistics());
    }

    private Map<String, JobStatisticsBasic> aggregateJobStatsByTime(long startTime, long endTime, String timeDimension) {
        HashMap result = Maps.newHashMap();
        long startDate = startTime;
        while (startDate <= endTime) {
            long nextDate = this.nextDate(startDate, timeDimension);
            List<JobStatistics> list = this.getFilteredJobStatsByTime(startDate, nextDate);
            result.put(this.formatDateTime(startDate), this.aggregateJobStats(list));
            startDate = nextDate;
        }
        return result;
    }

    private String formatDateTime(long time) {
        ZoneId zoneId = TimeZone.getDefault().toZoneId();
        LocalDateTime localDateTime = Instant.ofEpochMilli(time).atZone(zoneId).toLocalDateTime();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.getDefault(Locale.Category.FORMAT));
        return localDateTime.format(formatter);
    }

    private long nextDate(long date, String timeDimension) {
        ZoneId zoneId = TimeZone.getTimeZone(this.config.getTimeZone()).toZoneId();
        LocalDate localDate = Instant.ofEpochMilli(date).atZone(zoneId).toLocalDate();
        switch (timeDimension) {
            case "day": {
                localDate = localDate.plusDays(1L);
                break;
            }
            case "week": {
                localDate = localDate.with(TemporalAdjusters.next(DayOfWeek.MONDAY));
                break;
            }
            case "month": {
                localDate = localDate.with(TemporalAdjusters.firstDayOfNextMonth());
                break;
            }
            default: {
                localDate = localDate.plusDays(1L);
            }
        }
        return localDate.atStartOfDay(zoneId).toInstant().toEpochMilli();
    }

    private Map<String, JobStatisticsBasic> aggregateStatsByModel(long startTime, long endTime) {
        return this.getFilteredJobStatsByTime(startTime, endTime).stream().map(JobStatistics::getJobStatisticsByModels).reduce((x, y) -> {
            HashMap mergedMap = Maps.newHashMap((Map)x);
            y.forEach((k, v) -> mergedMap.merge(k, v, (value1, value2) -> new JobStatisticsBasic(value1.getCount() + value2.getCount(), value1.getTotalDuration() + value2.getTotalDuration(), value1.getTotalByteSize() + value2.getTotalByteSize())));
            return mergedMap;
        }).orElse(Maps.newHashMap());
    }

    private List<JobStatistics> getFilteredJobStatsByTime(long startTime, long endTime) {
        RawResourceFilter filter = new RawResourceFilter();
        filter.addConditions("timeOfDay", Collections.singletonList(startTime), RawResourceFilter.Operator.GE).addConditions("timeOfDay", Collections.singletonList(endTime), RawResourceFilter.Operator.LT);
        return this.crud.listByFilter(filter);
    }

    private Map<String, Double> calculateDurationPerByte(Map<String, JobStatisticsBasic> totalMetricMap) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, JobStatisticsBasic> entry : totalMetricMap.entrySet()) {
            double totalDuration = entry.getValue().getTotalDuration();
            double totalByteSize = entry.getValue().getTotalByteSize();
            if (totalByteSize == 0.0) {
                result.put(entry.getKey(), 0.0);
                continue;
            }
            result.put(entry.getKey(), totalDuration / totalByteSize);
        }
        return result;
    }
}

