/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.spring.util;

import java.beans.Introspector;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.AliasRegistry;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class BeanRegistrar {
    private static final Log log = LogFactory.getLog(BeanRegistrar.class);

    public static boolean registerInfrastructureBean(BeanDefinitionRegistry beanDefinitionRegistry, String beanName, Class<?> beanType) {
        boolean registered = false;
        if (!beanDefinitionRegistry.containsBeanDefinition(beanName)) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(beanType);
            beanDefinition.setRole(2);
            beanDefinitionRegistry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
            registered = true;
            if (log.isInfoEnabled()) {
                log.info((Object)("The Infrastructure bean definition [" + beanDefinition + "with name [" + beanName + "] has been registered."));
            }
        }
        return registered;
    }

    public static boolean hasAlias(AliasRegistry registry, String beanName, String alias) {
        return StringUtils.hasText((String)beanName) && StringUtils.hasText((String)alias) && ObjectUtils.containsElement((Object[])registry.getAliases(beanName), (Object)alias);
    }

    public static int registerSpringFactoriesBeans(BeanDefinitionRegistry registry, Class<?> ... factoryClasses) {
        int count = 0;
        ClassLoader classLoader = registry.getClass().getClassLoader();
        for (int i = 0; i < factoryClasses.length; ++i) {
            Class<?> factoryClass = factoryClasses[i];
            List factoryImplClassNames = SpringFactoriesLoader.loadFactoryNames(factoryClass, (ClassLoader)classLoader);
            for (String factoryImplClassName : factoryImplClassNames) {
                Class factoryImplClass = ClassUtils.resolveClassName((String)factoryImplClassName, (ClassLoader)classLoader);
                String beanName = Introspector.decapitalize(ClassUtils.getShortName((String)factoryImplClassName));
                if (BeanRegistrar.registerInfrastructureBean(registry, beanName, factoryImplClass)) {
                    ++count;
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("The Factory Class bean[%s] has been registered with bean name[%s]", factoryImplClassName, beanName));
            }
        }
        return count;
    }
}

