/*
 * Decompiled with CFR 0.152.
 */
package io.kyligence.config.external.util;

import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Locale;

public class EnvUtil {
    private static final String KYLIN_NEED_PUBLISH_CONFIG_PROPERTY = "kylin.external.config.initialized";

    public static boolean isNeedInitialized() {
        return EnvUtil.getSystemPropertyOrEnvVar(KYLIN_NEED_PUBLISH_CONFIG_PROPERTY, Boolean.TRUE);
    }

    public static String convertSystemPropertyNameToEnvVar(String systemPropertyName) {
        return systemPropertyName.toUpperCase(Locale.ROOT).replaceAll("[.-]", "_");
    }

    public static String getEnvVar(String envVarName, String defaultValue) {
        String answer = System.getenv(envVarName);
        return StringUtils.isBlank((CharSequence)answer) ? answer : defaultValue;
    }

    public static String getSystemPropertyOrEnvVar(String systemPropertyName, String defaultValue) {
        return EnvUtil.getSystemPropertyOrEnvVar(systemPropertyName, EnvUtil.convertSystemPropertyNameToEnvVar(systemPropertyName), defaultValue);
    }

    public static String getSystemPropertyOrEnvVar(String systemPropertyName) {
        return EnvUtil.getSystemPropertyOrEnvVar(systemPropertyName, (String)null);
    }

    public static boolean getSystemPropertyOrEnvVar(String systemPropertyName, Boolean defaultValue) {
        String result = EnvUtil.getSystemPropertyOrEnvVar(systemPropertyName, defaultValue.toString());
        return Boolean.parseBoolean(result);
    }

    public static int getSystemPropertyOrEnvVar(String systemPropertyName, int defaultValue) {
        String result = EnvUtil.getSystemPropertyOrEnvVar(systemPropertyName, Integer.toString(defaultValue));
        return Integer.parseInt(result);
    }

    public static String getSystemPropertyOrEnvVar(String systemPropertyName, String envVarName, String defaultValue) {
        String answer = System.getProperty(systemPropertyName);
        if (StringUtils.isNotBlank((String)answer)) {
            return answer;
        }
        answer = System.getenv(envVarName);
        if (StringUtils.isNotBlank((String)answer)) {
            return answer;
        }
        return defaultValue;
    }
}

