/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.restclient;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.CommonErrorCode;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.transaction.BroadcastEventReadyNotifier;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;

public class RestClient {
    private static final Logger logger = LoggerFactory.getLogger(RestClient.class);
    private static final Pattern FULL_REST_PATTERN = Pattern.compile("(?:([^:]+)[:]([^@]+)[@])?([^:]+)(?:[:](\\d+))?");
    private static final int HTTP_CONNECTION_TIMEOUT_MS = 30000;
    private static final int HTTP_SOCKET_TIMEOUT_MS = 120000;
    public static final String ROUTED = "routed";
    private static final String COOKIE = "Cookie";
    private static final String AUTHORIZATION = "Authorization";
    private static final String SCHEME_HTTP = "http://";
    private static final String KYLIN_API_PATH = "/kylin/api";
    protected String host;
    protected int port;
    protected String baseUrl;
    protected String userName;
    protected String password;
    protected DefaultHttpClient client;

    public static boolean matchFullRestPattern(String uri) {
        return FULL_REST_PATTERN.matcher(uri).matches();
    }

    public RestClient(String uri) {
        Matcher m = FULL_REST_PATTERN.matcher(uri);
        if (!m.matches()) {
            throw new IllegalArgumentException("URI: " + uri + " -- does not match pattern " + FULL_REST_PATTERN);
        }
        String mUser = m.group(1);
        String mPwd = m.group(2);
        String mHost = m.group(3);
        String mPortStr = m.group(4);
        int mPort = Integer.parseInt(mPortStr == null ? "7070" : mPortStr);
        this.init(mHost, mPort, mUser, mPwd);
    }

    public RestClient(String host, int port, String userName, String password) {
        this.init(host, port, userName, password);
    }

    private void init(String host, int port, String userName, String password) {
        this.host = host;
        this.port = port;
        this.userName = userName;
        this.password = password;
        this.baseUrl = SCHEME_HTTP + host + ":" + port + KYLIN_API_PATH;
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)120000);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)30000);
        PoolingClientConnectionManager cm = new PoolingClientConnectionManager();
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        cm.setDefaultMaxPerRoute(config.getRestClientDefaultMaxPerRoute());
        cm.setMaxTotal(config.getRestClientMaxTotal());
        this.client = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)httpParams);
        if (userName != null && password != null) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userName, password);
            provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            this.client.setCredentialsProvider((CredentialsProvider)provider);
        }
    }

    public RestClient resetBaseUrlWithoutKylin() {
        this.baseUrl = SCHEME_HTTP + this.host + ":" + this.port;
        return this;
    }

    public HttpResponse query(String sql, String project) throws IOException {
        String url = this.baseUrl + "/query";
        HttpPost post = this.newPost(url);
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("sql", sql);
        paraMap.put("project", project);
        String jsonMsg = new ObjectMapper().writeValueAsString(paraMap);
        post.setEntity((HttpEntity)new StringEntity(jsonMsg, "UTF-8"));
        return this.client.execute((HttpUriRequest)post);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse updateSourceUsage() throws IOException {
        String url = this.baseUrl + "/broadcast/capacity/refresh_all";
        HttpPut put = this.newPut(url);
        put.addHeader(ROUTED, "true");
        CloseableHttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)put);
            if (response.getStatusLine().getStatusCode() != 200) {
                String msg = EntityUtils.toString((HttpEntity)response.getEntity());
                logger.error("Invalid response: {} for refresh capacity: {} \n{}", new Object[]{response.getStatusLine().getStatusCode(), url, msg});
            }
        }
        finally {
            this.cleanup((HttpRequestBase)put, (HttpResponse)response);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse notify(BroadcastEventReadyNotifier notifier) throws IOException {
        String url = this.baseUrl + "/broadcast";
        HttpPost post = this.newPost(url);
        post.addHeader(ROUTED, "true");
        CloseableHttpResponse response = null;
        try {
            post.setEntity((HttpEntity)new ByteArrayEntity(JsonUtil.writeValueAsBytes(notifier), ContentType.APPLICATION_JSON));
            response = this.client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != 200) {
                String msg = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_NOTIFY_CATCHUP, "Invalid response " + response.getStatusLine().getStatusCode() + " with notify catch up url " + url + "\n" + msg);
            }
            this.cleanup((HttpRequestBase)post, (HttpResponse)response);
        }
        catch (Throwable throwable) {
            this.cleanup((HttpRequestBase)post, (HttpResponse)response);
            throw throwable;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse forwardGet(HttpHeaders headers, String targetUrl, boolean autoClean) throws IOException {
        String url = this.baseUrl + targetUrl;
        HttpGet get = this.newGet(url);
        get.addHeader(ROUTED, "true");
        get.addHeader(AUTHORIZATION, headers.getFirst(AUTHORIZATION));
        get.addHeader(COOKIE, headers.getFirst(COOKIE));
        CloseableHttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() != 200) {
                String msg = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_FORWARD_METADATA_ACTION, response.getStatusLine().getStatusCode() + "\n" + url + "\n" + msg);
            }
        }
        finally {
            if (autoClean) {
                this.cleanup((HttpRequestBase)get, (HttpResponse)response);
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse forwardPut(byte[] requestEntity, HttpHeaders headers, String targetUrl, boolean autoClean) throws IOException {
        String url = this.baseUrl + targetUrl;
        HttpPut put = this.newPut(url);
        put.addHeader(ROUTED, "true");
        put.addHeader(AUTHORIZATION, headers.getFirst(AUTHORIZATION));
        put.addHeader(COOKIE, headers.getFirst(COOKIE));
        CloseableHttpResponse response = null;
        try {
            put.setEntity((HttpEntity)new ByteArrayEntity(requestEntity, ContentType.APPLICATION_JSON));
            response = this.client.execute((HttpUriRequest)put);
            if (response.getStatusLine().getStatusCode() != 200) {
                String msg = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_FORWARD_METADATA_ACTION, "Invalid response " + response.getStatusLine().getStatusCode() + " with url " + url + "\n" + msg);
            }
            if (autoClean) {
                this.cleanup((HttpRequestBase)put, (HttpResponse)response);
            }
        }
        catch (Throwable throwable) {
            if (autoClean) {
                this.cleanup((HttpRequestBase)put, (HttpResponse)response);
            }
            throw throwable;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse forwardPostWithUrlEncodedForm(String targetUrl, HttpHeaders headers, Map<String, String> form) throws IOException {
        String url = this.baseUrl + targetUrl;
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-type", "application/x-www-form-urlencoded; charset=utf-8");
        httpPost.addHeader(ROUTED, "true");
        if (null != headers) {
            httpPost.addHeader(AUTHORIZATION, headers.getFirst(AUTHORIZATION));
            httpPost.addHeader(COOKIE, headers.getFirst(COOKIE));
        }
        ArrayList nameValuePairs = new ArrayList();
        if (null != form) {
            form.entrySet().forEach(entry -> nameValuePairs.add(new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue())));
        }
        CloseableHttpResponse response = null;
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, "UTF-8"));
            response = this.client.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                String msg = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_FORWARD_METADATA_ACTION, "Invalid response " + response.getStatusLine().getStatusCode() + " with url " + url + "\n" + msg);
            }
            this.cleanup((HttpRequestBase)httpPost, (HttpResponse)response);
        }
        catch (Throwable throwable) {
            this.cleanup((HttpRequestBase)httpPost, (HttpResponse)response);
            throw throwable;
        }
        return response;
    }

    public HttpResponse forwardPost(byte[] requestEntity, String targetUrl) throws IOException {
        String url = this.baseUrl + targetUrl;
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader(ROUTED, "true");
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(requestEntity, ContentType.APPLICATION_JSON));
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)httpPost);
        if (response.getStatusLine().getStatusCode() != 200) {
            String msg = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_FORWARD_METADATA_ACTION, "Invalid response " + response.getStatusLine().getStatusCode() + " with url " + url + "\n" + msg);
        }
        return response;
    }

    private void addHttpHeaders(HttpRequestBase method) {
        method.addHeader("Accept", "application/json, text/plain, */*");
        method.addHeader("Content-Type", "application/json");
    }

    private HttpGet newGet(String url) {
        HttpGet get = new HttpGet(url);
        this.addHttpHeaders((HttpRequestBase)get);
        return get;
    }

    private HttpPost newPost(String url) {
        HttpPost post = new HttpPost(url);
        this.addHttpHeaders((HttpRequestBase)post);
        return post;
    }

    private HttpPut newPut(String url) {
        HttpPut put = new HttpPut(url);
        this.addHttpHeaders((HttpRequestBase)put);
        return put;
    }

    private String getContent(HttpResponse response) throws IOException {
        StringBuilder result = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(response.getEntity().getContent(), Charset.defaultCharset());
             BufferedReader rd = new BufferedReader(reader);){
            String line;
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
        }
        return result.toString();
    }

    private void cleanup(HttpRequestBase request, HttpResponse response) {
        try {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        catch (Exception ex) {
            logger.error("Error during HTTP connection cleanup", (Throwable)ex);
        }
        request.releaseConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getKapHealthStatus(TypeReference<T> clz, byte[] encryptedToken) throws IOException, URISyntaxException {
        T t;
        String url = this.baseUrl + "/kg/health/instance_info";
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(encryptedToken));
        CloseableHttpResponse response = null;
        try {
            httpPost.setURI(new URI(url));
            response = this.client.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                String msg = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + " with health status url " + url + "\n" + msg);
            }
            t = JsonUtil.readValue(this.getContent((HttpResponse)response), clz);
            this.cleanup((HttpRequestBase)httpPost, (HttpResponse)response);
        }
        catch (Throwable throwable) {
            this.cleanup((HttpRequestBase)httpPost, (HttpResponse)response);
            throw throwable;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downOrUpGradeKE(String status, byte[] encryptedToken) throws IOException, URISyntaxException {
        String url = this.baseUrl + "/kg/health/instance_service/" + status;
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(encryptedToken));
        CloseableHttpResponse response = null;
        try {
            httpPost.setURI(new URI(url));
            response = this.client.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                String msg = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + " with downOrUpGradeKE url " + url + "\n" + msg);
            }
            this.cleanup((HttpRequestBase)httpPost, (HttpResponse)response);
        }
        catch (Throwable throwable) {
            this.cleanup((HttpRequestBase)httpPost, (HttpResponse)response);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateDiagProgress(String diagId, String stage, float progress, long updateTime) {
        String url = this.baseUrl + "/system/diag/progress";
        HttpPut put = this.newPut(url);
        CloseableHttpResponse response = null;
        try {
            HashMap paraMap = Maps.newHashMap();
            paraMap.put("diag_id", diagId);
            paraMap.put("stage", stage);
            paraMap.put("progress", Float.valueOf(progress));
            paraMap.put("updateTime", updateTime);
            put.setEntity((HttpEntity)new StringEntity(new ObjectMapper().writeValueAsString((Object)paraMap), "UTF-8"));
            response = this.client.execute((HttpUriRequest)put);
            if (response.getStatusLine().getStatusCode() != 200) {
                String msg = EntityUtils.toString((HttpEntity)response.getEntity());
                logger.warn("Invalid response {} with updateDiagProgress url: {}\n{}", new Object[]{response.getStatusLine().getStatusCode(), url, msg});
                boolean bl = false;
                this.cleanup((HttpRequestBase)put, (HttpResponse)response);
                return bl;
            }
            this.cleanup((HttpRequestBase)put, (HttpResponse)response);
        }
        catch (Exception e) {
            logger.warn("Error during update diag progress", (Throwable)e);
        }
        finally {
            this.cleanup((HttpRequestBase)put, (HttpResponse)response);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rollUpEventLog() {
        String url = this.baseUrl + "/system/roll_event_log";
        HttpPut put = this.newPut(url);
        CloseableHttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)put);
            if (response.getStatusLine().getStatusCode() != 200) {
                String msg = EntityUtils.toString((HttpEntity)response.getEntity());
                logger.warn("Invalid response {}  rollup event_log url: {}\n{}", new Object[]{response.getStatusLine().getStatusCode(), url, msg});
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            logger.warn("Error during get rollup event_log");
        }
        finally {
            this.cleanup((HttpRequestBase)put, (HttpResponse)response);
        }
        return true;
    }

    private void tryCatchUp() {
        try {
            ResourceStore store = ResourceStore.getKylinMetaStore(KylinConfig.getInstanceFromEnv());
            store.getAuditLogStore().catchupWithTimeout();
        }
        catch (Exception e) {
            logger.error("Failed to catchup manually.", (Throwable)e);
        }
    }
}

