/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.CommonErrorCode;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;

public class ZipFileUtils {
    public static void decompressZipFile(String zipFilename, String targetDir) throws IOException {
        if (!ZipFileUtils.validateZipFilename(zipFilename)) {
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.INVALID_ZIP_NAME, "Zipfile must end with .zip");
        }
        String normalizedTargetDir = Paths.get(targetDir, new String[0]).normalize().toString();
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zipFilename));){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String entryDir = Paths.get(targetDir, entry.getName()).normalize().toString();
                if (!entryDir.startsWith(normalizedTargetDir)) {
                    throw new KylinException((ErrorCodeSupplier)CommonErrorCode.INVALID_ZIP_ENTRY, "Zip Entry <" + entry.getName() + "> is Invalid");
                }
                if (entry.isDirectory()) {
                    Files.createDirectories(Paths.get(entryDir, new String[0]), new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(Paths.get(entryDir, new String[0]).getParent(), new FileAttribute[0]);
                Files.copy(zipInputStream, Paths.get(targetDir, entry.getName()), new CopyOption[0]);
            }
        }
    }

    public static void compressZipFile(String sourceDir, OutputStream outputStream) throws IOException {
        ZipOutputStream zipFile = null;
        try {
            zipFile = new ZipOutputStream(outputStream);
            ZipFileUtils.compressDirectoryToZipfile(ZipFileUtils.normDir(new File(sourceDir).getParent()), ZipFileUtils.normDir(sourceDir), zipFile);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zipFile);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)zipFile);
    }

    public static void compressZipFile(String sourceDir, String zipFilename) throws IOException {
        if (!ZipFileUtils.validateZipFilename(zipFilename)) {
            throw new RuntimeException("Zipfile must end with .zip");
        }
        ZipFileUtils.compressZipFile(sourceDir, new FileOutputStream(zipFilename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compressDirectoryToZipfile(String rootDir, String sourceDir, ZipOutputStream out) throws IOException {
        File[] files = new File(sourceDir).listFiles();
        if (files == null) {
            return;
        }
        if (files.length == 0) {
            out.putNextEntry(new ZipEntry(ZipFileUtils.normDir(StringUtils.isEmpty((CharSequence)rootDir) ? sourceDir : sourceDir.replace(rootDir, ""))));
        }
        for (File sourceFile : files) {
            if (sourceFile.isDirectory()) {
                ZipFileUtils.compressDirectoryToZipfile(rootDir, sourceDir + ZipFileUtils.normDir(sourceFile.getName()), out);
                continue;
            }
            ZipEntry entry = new ZipEntry(ZipFileUtils.normDir(StringUtils.isEmpty((CharSequence)rootDir) ? sourceDir : sourceDir.replace(rootDir, "")) + sourceFile.getName());
            entry.setTime(sourceFile.lastModified());
            out.putNextEntry(entry);
            FileInputStream in = new FileInputStream(sourceDir + sourceFile.getName());
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    public static boolean validateZipFilename(String filename) {
        return !StringUtils.isEmpty((CharSequence)filename) && filename.trim().toLowerCase(Locale.ROOT).endsWith(".zip");
    }

    private static String normDir(String dirName) {
        if (!StringUtils.isEmpty((CharSequence)dirName) && !dirName.endsWith(File.separator)) {
            dirName = dirName + File.separator;
        }
        return dirName;
    }
}

