/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import lombok.Generated;
import org.apache.kylin.common.util.ExpModifierConstants;
import org.apache.kylin.common.util.ExpModifierTokenManager;
import org.apache.kylin.common.util.ParseException;
import org.apache.kylin.common.util.SimpleCharStream;
import org.apache.kylin.common.util.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpModifier
implements ExpModifierConstants {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExpModifier.class);
    private String exp;
    public ExpModifierTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[3];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static void main(String[] args) throws ParseException {
        Scanner reader = new Scanner(System.in, Charset.defaultCharset().name());
        while (true) {
            System.out.println("Input the expression: ");
            String sql = reader.nextLine();
            ExpModifier modifier = new ExpModifier(new StringReader(sql));
            String parseResult = modifier.transform();
            System.out.println("The translated expression is: ");
            System.out.println(parseResult);
        }
    }

    public ExpModifier(String exp) {
        this(new StringReader(exp));
    }

    public final String transform() throws ParseException {
        StringBuilder sb = new StringBuilder();
        while (this.jj_2_1(2)) {
            String innerString = this.expression();
            sb.append(innerString);
        }
        this.jj_consume_token(0);
        String str = sb.toString();
        str = str.replaceAll("\\(\\)\\(\\s*\\)", "()");
        return str;
    }

    public final String space() throws ParseException {
        this.jj_consume_token(1);
        log.trace("meet token <SPACE>");
        return this.getToken((int)0).image;
    }

    public final String punctuation() throws ParseException {
        this.jj_consume_token(8);
        String s = this.getToken((int)0).image;
        log.trace("meet token: {}", (Object)s);
        return s;
    }

    public final String any() throws ParseException {
        this.jj_consume_token(15);
        log.trace("meet token in <ANY>: {}", (Object)this.getToken((int)0).image);
        return this.getToken((int)0).image;
    }

    public final String doubleQuotedString() throws ParseException {
        this.jj_consume_token(14);
        log.trace("meet token in quoted identifier: {}", (Object)this.getToken((int)0).image);
        return this.getToken((int)0).image;
    }

    public final String quotedString() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        log.trace("meet token quote String: {}", (Object)this.getToken((int)0).image);
        return this.getToken((int)0).image;
    }

    public final String niladicFunction() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                break;
            }
            case 3: {
                this.jj_consume_token(3);
                break;
            }
            case 2: {
                this.jj_consume_token(2);
                break;
            }
            case 5: {
                this.jj_consume_token(5);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        log.trace("meet token of niladic function: {}", (Object)this.getToken((int)0).image);
        return this.getToken((int)0).image + "()";
    }

    public final String expression() throws ParseException {
        String innerString = "";
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                innerString = this.doubleQuotedString();
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                innerString = this.quotedString();
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                innerString = this.niladicFunction();
                break;
            }
            case 8: {
                innerString = this.punctuation();
                break;
            }
            case 1: {
                innerString = this.space();
                break;
            }
            case 15: {
                innerString = this.any();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return innerString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private boolean jj_3R_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(4)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(3)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(2)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(5)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_12() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3R_9() {
        return this.jj_scan_token(14);
    }

    private boolean jj_3R_8() {
        return this.jj_3R_14();
    }

    private boolean jj_3R_7() {
        return this.jj_3R_13();
    }

    private boolean jj_3R_6() {
        return this.jj_3R_12();
    }

    private boolean jj_3R_5() {
        return this.jj_3R_11();
    }

    private boolean jj_3R_4() {
        return this.jj_3R_10();
    }

    private boolean jj_3_1() {
        return this.jj_3R_2();
    }

    private boolean jj_3R_3() {
        return this.jj_3R_9();
    }

    private boolean jj_3R_13() {
        return this.jj_scan_token(1);
    }

    private boolean jj_3R_2() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_3()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_4()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_5()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_6()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_7()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_8()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_14() {
        return this.jj_scan_token(15);
    }

    private boolean jj_3R_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(10)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(11)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(12)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{7680, 60, 57150};
    }

    public ExpModifier(InputStream stream) {
        this(stream, null);
    }

    public ExpModifier(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ExpModifierTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ExpModifier(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ExpModifierTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ExpModifier(ExpModifierTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ExpModifierTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[16];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 3; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 16; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ExpModifier.jj_la1_init_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

