/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.transaction;

import java.io.IOException;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.UnitMessages;
import org.apache.kylin.common.persistence.event.ResourceCreateOrUpdateEvent;
import org.apache.kylin.common.persistence.event.ResourceDeleteEvent;
import org.apache.kylin.common.persistence.metadata.FileSystemMetadataStore;
import org.apache.kylin.common.persistence.transaction.AbstractAuditLogReplayWorker;
import org.apache.kylin.common.persistence.transaction.EventListenerRegistry;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSynchronization {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageSynchronization.class);
    private final KylinConfig config;
    private final EventListenerRegistry eventListener;
    private ResourceStore.Callback<Boolean> checker;

    public static MessageSynchronization getInstance(KylinConfig config) {
        return config.getManager(MessageSynchronization.class);
    }

    static MessageSynchronization newInstance(KylinConfig config) {
        return new MessageSynchronization(config);
    }

    private MessageSynchronization(KylinConfig config) {
        this.config = config;
        this.eventListener = EventListenerRegistry.getInstance(config);
    }

    public void replay(UnitMessages messages) {
        if (messages.isEmpty()) {
            return;
        }
        if (this.checker != null && this.checker.check(messages).booleanValue()) {
            return;
        }
        this.replayInTransaction(messages);
    }

    synchronized void replayInTransaction(UnitMessages messages) {
        UnitOfWork.replaying.set(true);
        messages.getMessages().forEach(event -> {
            if (event instanceof ResourceCreateOrUpdateEvent) {
                this.replayUpdate((ResourceCreateOrUpdateEvent)event);
                this.eventListener.onUpdate((ResourceCreateOrUpdateEvent)event);
            } else if (event instanceof ResourceDeleteEvent) {
                this.replayDelete((ResourceDeleteEvent)event);
                this.eventListener.onDelete((ResourceDeleteEvent)event);
            }
        });
        UnitOfWork.replaying.remove();
    }

    private void replayDelete(ResourceDeleteEvent event) {
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore(this.config);
        log.trace("replay delete for res {}", (Object)event.getResPath());
        resourceStore.deleteResource(event.getResPath());
    }

    private void replayUpdate(ResourceCreateOrUpdateEvent event) {
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore(this.config);
        log.trace("replay update for res {}, with new version: {}", (Object)event.getResPath(), (Object)event.getCreatedOrUpdated().getMvcc());
        RawResource raw = event.getCreatedOrUpdated();
        String resPath = event.getResPath();
        RawResource oldRaw = resourceStore.getResource(resPath);
        if (!this.config.isJobNode() && raw.getContentDiff() == null) {
            resourceStore.putResourceWithoutCheck(resPath, raw.getByteSource(), raw.getTs(), raw.getMvcc());
            return;
        }
        if (oldRaw == null) {
            if (raw.getContentDiff() != null) {
                throw new IllegalStateException("No pre-update data found, unable to calculate json diff! metaKey: " + raw.getMetaKey());
            }
            resourceStore.putResourceWithoutCheck(resPath, raw.getByteSource(), raw.getTs(), raw.getMvcc());
        } else {
            ByteSource byteSource;
            ByteSource byteSource2 = byteSource = raw.getContentDiff() != null ? RawResource.applyContentDiffFromRaw(oldRaw, raw) : raw.getByteSource();
            if (resourceStore.getMetadataStore() instanceof FileSystemMetadataStore) {
                resourceStore.putResourceWithoutCheck(resPath, byteSource, raw.getTs(), raw.getMvcc(), true);
            } else {
                resourceStore.checkAndPutResource(resPath, byteSource, raw.getTs(), raw.getMvcc() - 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayAllMetadata(boolean needCloseReplay) throws IOException {
        boolean needResetUrl;
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore(KylinConfig.getInstanceFromEnv());
        String curMetaUrl = null;
        boolean bl = needResetUrl = !this.config.isJobNode() && this.config.getMetadataStoreType().equals("hdfs") && !this.config.isAuditLogOnlyOriginalEnabled();
        if (needResetUrl) {
            curMetaUrl = this.config.getMetadataUrl().toString();
            this.config.setMetadataUrl(this.config.getCoreMetadataDBUrl().toString());
            log.info("Replay all metadata by jdbc url");
        }
        try {
            EventBusFactory.getInstance().postSync(new AbstractAuditLogReplayWorker.StartReloadEvent());
            if (needCloseReplay) {
                resourceStore.getAuditLogStore().pause();
            }
            log.info("Acquired all locks, start to reload");
            resourceStore.reload();
            log.info("Reload finished");
        }
        finally {
            if (needResetUrl) {
                this.config.setMetadataUrl(curMetaUrl);
                log.info("Finished replay, reset metadata url to {}", (Object)curMetaUrl);
            }
            if (needCloseReplay) {
                resourceStore.getAuditLogStore().reInit();
            } else {
                resourceStore.getAuditLogStore().catchup();
            }
            EventBusFactory.getInstance().postSync(new AbstractAuditLogReplayWorker.EndReloadEvent());
        }
    }

    @Generated
    public void setChecker(ResourceStore.Callback<Boolean> checker) {
        this.checker = checker;
    }
}

