/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.AuditLog;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.UnitMessages;
import org.apache.kylin.common.persistence.event.ResourceCreateOrUpdateEvent;
import org.apache.kylin.common.persistence.event.ResourceDeleteEvent;
import org.apache.kylin.common.persistence.metadata.AuditLogStore;
import org.apache.kylin.common.persistence.transaction.AuditLogReplayWorker;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.springframework.security.core.context.SecurityContextHolder;

public class MemoryAuditLogStore
implements AuditLogStore {
    private String instance = AddressUtil.getLocalInstance();
    private final List<AuditLog> logs = new ArrayList<AuditLog>();
    private final AtomicLong maxId = new AtomicLong(0L);
    private final AuditLogReplayWorker replayWorker;
    private final KylinConfig config;

    public MemoryAuditLogStore(KylinConfig config) {
        this.config = config;
        this.replayWorker = new AuditLogReplayWorker(config, this);
    }

    @Override
    public void save(UnitMessages unitMessages) {
        String unitId = unitMessages.getUnitId();
        String operator = Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).map(Principal::getName).orElse(null);
        List newLogs = unitMessages.getMessages().stream().map(event -> {
            long id = this.maxId.addAndGet(1L);
            if (event instanceof ResourceCreateOrUpdateEvent) {
                ResourceCreateOrUpdateEvent e = (ResourceCreateOrUpdateEvent)event;
                RawResource raw = e.getCreatedOrUpdated();
                return new AuditLog(id, e.getResPath(), ByteSource.wrap((byte[])e.getMetaContent()), raw.getTs(), raw.getMvcc(), unitId, raw.getModelUuid(), operator, this.instance, raw.getProject(), raw.getContentDiff() != null);
            }
            if (event instanceof ResourceDeleteEvent) {
                ResourceDeleteEvent e = (ResourceDeleteEvent)event;
                return new AuditLog(id, e.getResPath(), null, System.currentTimeMillis(), null, unitId, null, operator, this.instance, e.getKey(), false);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        this.logs.addAll(newLogs);
    }

    @Override
    public List<AuditLog> fetch(long currentId, long size) {
        return this.logs.stream().filter(log -> log.getId() > currentId && log.getId() <= currentId + size).collect(Collectors.toList());
    }

    @Override
    public List<AuditLog> fetch(List<Long> auditIdList) {
        return this.logs.stream().filter(log -> auditIdList.contains(log.getId())).collect(Collectors.toList());
    }

    @Override
    public long getMaxId() {
        return this.maxId.get();
    }

    @Override
    public long getMinId() {
        return this.logs.isEmpty() ? 0L : 1L;
    }

    @Override
    public long getLogOffset() {
        return this.replayWorker.getLogOffset();
    }

    @Override
    public void restore(long currentId) {
    }

    @Override
    public void rotate() {
    }

    @Override
    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Override
    public AuditLog get(String resPath, long mvcc) {
        return this.logs.stream().filter(log -> log.getResPath().equals(resPath) && log.getMvcc() == mvcc).findFirst().orElse(null);
    }

    @Override
    public long count(long startId, long endId) {
        return this.logs.stream().filter(log -> log.getId() > startId && log.getId() <= endId).count();
    }

    @Override
    @Generated
    public AuditLogReplayWorker getReplayWorker() {
        return this.replayWorker;
    }

    @Override
    @Generated
    public KylinConfig getConfig() {
        return this.config;
    }
}

