/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigBase;
import org.apache.kylin.common.ReadFsSwitch;
import org.apache.kylin.common.annotation.Clarification;
import org.apache.kylin.common.util.EncryptUtil;
import org.apache.kylin.common.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Clarification(priority=Clarification.Priority.MAJOR, msg="Enterprise")
public class KapConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KapConfig.class);
    private final KylinConfig config;
    private static final String CIRCUIT_BREAKER_THRESHOLD = "30000";
    private static final String HALF_MINUTE_MS = "30000";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    public static final String FI_PLATFORM = "FI";
    public static final String TDH_PLATFORM = "TDH";
    public static final String CHANNEL_CLOUD = "cloud";

    public static KapConfig getInstanceFromEnv() {
        return KapConfig.wrap(KylinConfig.getInstanceFromEnv());
    }

    public static KapConfig wrap(KylinConfig config) {
        return new KapConfig(config);
    }

    public static File getKylinHomeAtBestEffort() {
        String kylinHome = KylinConfig.getKylinHome();
        if (kylinHome != null) {
            return new File(kylinHome).getAbsoluteFile();
        }
        File confFile = KylinConfig.getSitePropertiesFile();
        return confFile.getAbsoluteFile().getParentFile().getParentFile();
    }

    public static String getKylinLogDirAtBestEffort() {
        return new File(KapConfig.getKylinHomeAtBestEffort(), "logs").getAbsolutePath();
    }

    public static String getKylinConfDirAtBestEffort() {
        return new File(KapConfig.getKylinHomeAtBestEffort(), "conf").getAbsolutePath();
    }

    private KapConfig(KylinConfig config) {
        this.config = config;
    }

    public KylinConfig getKylinConfig() {
        return this.config;
    }

    public boolean isDevEnv() {
        return this.config.isDevEnv();
    }

    public String getWriteHdfsWorkingDirectory() {
        return this.config.getHdfsWorkingDirectory();
    }

    public String getReadHdfsWorkingDirectory() {
        String readFS = this.getParquetReadFileSystem();
        if (StringUtils.isNotEmpty((CharSequence)readFS)) {
            Path workingDir = new Path(this.getWriteHdfsWorkingDirectory());
            return new Path(readFS, Path.getPathWithoutSchemeAndAuthority((Path)workingDir)).toString() + "/";
        }
        return this.getWriteHdfsWorkingDirectory();
    }

    public String getMetadataWorkingDirectory() {
        if (this.isCloud()) {
            return this.getWriteHdfsWorkingDirectory();
        }
        return this.getReadHdfsWorkingDirectory();
    }

    public String getParquetReadFileSystem() {
        String fileSystem = this.config.getOptional("kylin.storage.columnar.file-system", "");
        String fileSystemBackup = this.config.getOptional("kylin.storage.columnar.file-system-backup", "");
        return ReadFsSwitch.select(fileSystem, fileSystemBackup);
    }

    public int getParquetReadFileSystemBackupResetSec() {
        return Integer.parseInt(this.config.getOptional("kylin.storage.columnar.file-system-backup-reset-sec", "1000"));
    }

    public int getParquetSparkExecutorInstance() {
        return Integer.parseInt(this.config.getOptional("kylin.storage.columnar.spark-conf.spark.executor.instances", String.valueOf(1)));
    }

    public int getParquetSparkExecutorCore() {
        return Integer.parseInt(this.config.getOptional("kylin.storage.columnar.spark-conf.spark.executor.cores", String.valueOf(1)));
    }

    public String getWriteParquetStoragePath(String project) {
        String defaultPath = this.config.getHdfsWorkingDirectory() + project + "/parquet/";
        return this.config.getOptional("kylin.storage.columnar.hdfs-dir", defaultPath);
    }

    public String getReadParquetStoragePath(String project) {
        String readFS = this.getParquetReadFileSystem();
        if (StringUtils.isNotEmpty((CharSequence)readFS)) {
            Path parquetPath = new Path(this.getWriteParquetStoragePath(project));
            return new Path(readFS, Path.getPathWithoutSchemeAndAuthority((Path)parquetPath)).toString() + "/";
        }
        return this.getWriteParquetStoragePath(project);
    }

    public int getMinBucketsNumber() {
        return Integer.parseInt(this.config.getOptional("kylin.storage.columnar.bucket-num", "1"));
    }

    public int getParquetStorageShardSizeMB() {
        return Integer.parseInt(this.config.getOptional("kylin.storage.columnar.shard-size-mb", "128"));
    }

    public long getParquetStorageShardSizeRowCount() {
        return Long.parseLong(this.config.getOptional("kylin.storage.columnar.shard-rowcount", "2500000"));
    }

    public long getParquetStorageCountDistinctShardSizeRowCount() {
        return Long.parseLong(this.config.getOptional("kylin.storage.columnar.shard-countdistinct-rowcount", "1000000"));
    }

    public int getParquetStorageRepartitionThresholdSize() {
        return Integer.parseInt(this.config.getOptional("kylin.storage.columnar.repartition-threshold-size-mb", "128"));
    }

    public boolean isResetMaxPartitionBytes() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.storage.columnar.reset-max-partition-bytes", FALSE));
    }

    public long getQueryParquetFilesThresholdBytes() {
        return Long.parseLong(this.config.getOptional("kylin.storage.columnar.files-threshold-bytes", "10485760"));
    }

    public long getQueryParquetRowCountThresholdSize() {
        return Long.parseLong(this.config.getOptional("kylin.storage.columnar.parquet-row-count-threshold-size", "10000000"));
    }

    public long getQueryParquetRowCountPerMb() {
        return Long.parseLong(this.config.getOptional("kylin.storage.columnar.parquet-row-count-per-mb", "1000000"));
    }

    public long getQueryFilesMaxPartitionBytes() {
        return Long.parseLong(this.config.getOptional("kylin.storage.columnar.files.max-partition-bytes", "134217728"));
    }

    public boolean isResetParquetBlockSize() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.engine.reset-parquet-block-size", FALSE));
    }

    public long getParquetRowCountPerMb() {
        return Long.parseLong(this.config.getOptional("kylin.engine.parquet-row-count-per-mb", "1000000"));
    }

    public long getParquetBlockSize() {
        return Long.parseLong(this.config.getOptional("kylin.engine.parquet-conf.parquet.block.size", "134217728"));
    }

    public long getParquetPageSizeRowCheckMax() {
        return Long.parseLong(this.config.getOptional("kylin.engine.parquet-conf.parquet.page.size.row.check.max", "10000"));
    }

    public boolean isProjectInternalDefaultPermissionGranted() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.acl.project-internal-default-permission-granted", TRUE));
    }

    public String getMassinResourceIdentiferDir() {
        return this.config.getOptional("kylin.server.massin-resource-dir", "/massin");
    }

    public String getZookeeperConnectString() {
        return this.config.getZookeeperConnectString();
    }

    public boolean getDBAccessFilterEnable() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.source.hive.database-access-filter-enabled", TRUE));
    }

    public long getDiagPackageTimeout() {
        return Long.parseLong(this.config.getOptional("kylin.diag.package.timeout-seconds", "3600"));
    }

    public int getExtractionStartTimeDays() {
        return Integer.parseInt(this.config.getOptional("kylin.diag.extraction.start-time-days", "3"));
    }

    public String getChannelUser() {
        return this.config.getOptional("kylin.env.channel", "on-premises");
    }

    public boolean isCloud() {
        return this.getChannelUser().equals(CHANNEL_CLOUD);
    }

    public String getColumnarSparkEnv(String conf) {
        return this.config.getPropertiesByPrefix("kylin.storage.columnar.spark-env.").get(conf);
    }

    public String getColumnarSparkConf(String conf) {
        return this.config.getPropertiesByPrefix("kylin.storage.columnar.spark-conf.").get(conf);
    }

    public Map<String, String> getSparkConf() {
        return this.config.getPropertiesByPrefix("kylin.storage.columnar.spark-conf.");
    }

    public String getSmartModelingConf(String conf) {
        return this.config.getOptional("kylin.smart.conf." + conf, null);
    }

    public boolean isJdbcEscapeEnabled() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.query.jdbc-escape-enabled", TRUE));
    }

    public int getListenerBusBusyThreshold() {
        return Integer.parseInt(this.config.getOptional("kylin.query.engine.spark-listenerbus-busy-threshold", "5000"));
    }

    public int getBlockNumBusyThreshold() {
        return Integer.parseInt(this.config.getOptional("kylin.query.engine.spark-blocknum-busy-threshold", "5000"));
    }

    public int getSparkSqlShufflePartitions() {
        return Integer.parseInt(this.config.getOptional("kylin.query.engine.spark-sql-shuffle-partitions", "-1"));
    }

    public Boolean isConstraintPropagationEnabled() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.query.engine.spark-constraint-propagation-enabled", FALSE));
    }

    public String getLDAPUserSearchFilter() {
        return this.config.getOptional("kylin.security.ldap.user-search-filter", "(objectClass=person)");
    }

    public String getLDAPGroupSearchFilter() {
        return this.config.getOptional("kylin.security.ldap.group-search-filter", "(|(objectClass=groupOfNames)(objectClass=group))");
    }

    public String getLDAPGroupMemberSearchFilter() {
        return this.config.getOptional("kylin.security.ldap.group-member-search-filter", "(&(cn={0})(objectClass=groupOfNames))");
    }

    public String getLDAPUserIDAttr() {
        return this.config.getOptional("kylin.security.ldap.user-identifier-attr", "cn");
    }

    public String getLDAPGroupIDAttr() {
        return this.config.getOptional("kylin.security.ldap.group-identifier-attr", "cn");
    }

    public String getLDAPGroupMemberAttr() {
        return this.config.getOptional("kylin.security.ldap.group-member-attr", "member");
    }

    public Integer getLDAPMaxPageSize() {
        return Integer.parseInt(this.config.getOptional("kylin.security.ldap.max-page-size", "1000"));
    }

    public Integer getLDAPMaxValRange() {
        return Integer.parseInt(this.config.getOptional("kylin.security.ldap.max-val-range", "1500"));
    }

    public boolean needReplaceAggWhenExactlyMatched() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.query.engine.need-replace-agg", TRUE));
    }

    public int getMetaStoreHealthWarningResponseMs() {
        return Integer.parseInt(this.config.getOptional("kylin.health.metastore-warning-response-ms", "300"));
    }

    public int getMetaStoreHealthErrorResponseMs() {
        return Integer.parseInt(this.config.getOptional("kylin.health.metastore-error-response-ms", "1000"));
    }

    public String influxdbAddress() {
        return this.config.getOptional("kylin.influxdb.address", "localhost:8086");
    }

    public String influxdbUsername() {
        return this.config.getOptional("kylin.influxdb.username", "root");
    }

    public String influxdbPassword() {
        String password = this.config.getOptional("kylin.influxdb.password", "root");
        if (EncryptUtil.isEncrypted(password)) {
            password = EncryptUtil.decryptPassInKylin(password);
        }
        return password;
    }

    public boolean isInfluxdbHttpsEnabled() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.influxdb.https.enabled", FALSE));
    }

    public boolean isInfluxdbUnsafeSslEnabled() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.influxdb.https.unsafe-ssl.enabled", TRUE));
    }

    public int getInfluxDBFlushDuration() {
        return Integer.parseInt(this.config.getOptional("kylin.influxdb.flush-duration", "3000"));
    }

    public String sparderJars() {
        try {
            File storageFile = FileUtils.findFile(KylinConfigBase.getKylinHome() + "/lib", "newten-job.jar");
            String path1 = "";
            if (storageFile != null) {
                path1 = storageFile.getCanonicalPath();
            }
            return this.config.getOptional("kylin.query.engine.sparder-additional-jars", path1);
        }
        catch (IOException e) {
            return "";
        }
    }

    public String getMetricsDbNameWithMetadataUrlPrefix() {
        StringBuilder sb = new StringBuilder(this.config.getMetadataUrlPrefix());
        sb.append("_");
        sb.append(this.config.getOptional("kylin.metrics.influx-db", "KYLIN_METRICS"));
        return sb.toString();
    }

    public String getDailyMetricsDbNameWithMetadataUrlPrefix() {
        StringBuilder sb = new StringBuilder(this.config.getMetadataUrlPrefix());
        sb.append("_");
        sb.append(this.config.getOptional("kylin.metrics.daily-influx-db", "KYLIN_METRICS_DAILY"));
        return sb.toString();
    }

    public String getMetricsRpcServiceBindAddress() {
        return this.config.getOptional("kylin.metrics.influx-rpc-service-bind-address", "127.0.0.1:8088");
    }

    public int getMetricsPollingIntervalSecs() {
        return Integer.parseInt(this.config.getOptional("kylin.metrics.polling-interval-secs", "60"));
    }

    public int getDailyMetricsRunHour() {
        return Integer.parseInt(this.config.getOptional("kylin.metrics.daily-run-hour", "1"));
    }

    public int getDailyMetricsMaxRetryTimes() {
        return Integer.parseInt(this.config.getOptional("kylin.metrics.daily-max-retry-times", "3"));
    }

    public boolean isMonitorEnabled() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.monitor.enabled", FALSE));
    }

    public String getMonitorDatabase() {
        return String.valueOf(this.config.getOptional("kylin.monitor.db", "KYLIN_MONITOR"));
    }

    public String getMonitorRetentionPolicy() {
        return String.valueOf(this.config.getOptional("kylin.monitor.retention-policy", "KYLIN_MONITOR_RP"));
    }

    public String getMonitorRetentionDuration() {
        return String.valueOf(this.config.getOptional("kylin.monitor.retention-duration", "90d"));
    }

    public String getMonitorShardDuration() {
        return String.valueOf(this.config.getOptional("kylin.monitor.shard-duration", "7d"));
    }

    public Integer getMonitorReplicationFactor() {
        return Integer.parseInt(this.config.getOptional("kylin.monitor.replication-factor", "1"));
    }

    public boolean isMonitorUserDefault() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.monitor.user-default", TRUE));
    }

    public Long getMonitorInterval() {
        return Long.parseLong(this.config.getOptional("kylin.monitor.interval", "60")) * 1000L;
    }

    public long getJobStatisticInterval() {
        return Long.parseLong(this.config.getOptional("kylin.monitor.job-statistic-interval", "3600")) * 1000L;
    }

    public long getMaxPendingErrorJobs() {
        return Long.parseLong(this.config.getOptional("kylin.monitor.job-pending-error-total", "20"));
    }

    public double getMaxPendingErrorJobsRation() {
        double ration = Double.parseDouble(this.config.getOptional("kylin.monitor.job-pending-error-rate", "0.2"));
        if (ration <= 0.0 || ration >= 1.0) {
            return 0.2;
        }
        return ration;
    }

    public double getClusterCrashThreshhold() {
        return Double.parseDouble(this.config.getOptional("kylin.monitor.cluster-crash-threshold", "0.8"));
    }

    public boolean isCircuitBreakerEnabled() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.circuit-breaker.enabled", TRUE));
    }

    public int getCircuitBreakerThresholdOfProject() {
        return Integer.parseInt(this.config.getOptional("kylin.circuit-breaker.threshold.project", "100"));
    }

    public int getCircuitBreakerThresholdOfModel() {
        return Integer.parseInt(this.config.getOptional("kylin.circuit-breaker.threshold.model", "100"));
    }

    public int getCircuitBreakerThresholdOfFavoriteQuery() {
        return Integer.parseInt(this.config.getOptional("kylin.circuit-breaker.threshold.fq", "30000"));
    }

    public int getCircuitBreakerThresholdOfSqlPatternToBlacklist() {
        return Integer.parseInt(this.config.getOptional("kylin.circuit-breaker.threshold.sql-pattern-to-blacklist", "30000"));
    }

    public long getCircuitBreakerThresholdOfQueryResultRowCount() {
        return Long.parseLong(this.config.getOptional("kylin.circuit-breaker.threshold.query-result-row-count", "2000000"));
    }

    public int getMaxKeepLogFileNumber() {
        return Integer.parseInt(this.config.getOptional("kylin.env.max-keep-log-file-number", "10"));
    }

    public int getMaxKeepLogFileThresholdMB() {
        return Integer.parseInt(this.config.getOptional("kylin.env.max-keep-log-file-threshold-mb", "256"));
    }

    public String sparderFiles() {
        try {
            File storageFile = new File(this.config.getLogSparkExecutorPropertiesFile());
            String additionalFiles = storageFile.getCanonicalPath();
            storageFile = new File(this.config.getLogSparkAppMasterPropertiesFile());
            additionalFiles = additionalFiles.isEmpty() ? storageFile.getCanonicalPath() : additionalFiles + "," + storageFile.getCanonicalPath();
            if (this.config.asyncProfilingEnabled()) {
                additionalFiles = additionalFiles + "," + this.config.getAsyncProfilerFiles();
            }
            log.info("Sparder additionalFiles: {}", (Object)additionalFiles);
            return this.config.getOptional("kylin.query.engine.sparder-additional-files", additionalFiles);
        }
        catch (IOException e) {
            log.error("Add sparderFiles failed, " + e);
            return "";
        }
    }

    public String getAsyncResultBaseDir(String project) {
        return this.config.getOptional("kylin.query.engine.sparder-asyncresult-base-dir", KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory(project) + "/async_query_result");
    }

    public String getCuboidSpanningTree() {
        return this.config.getOptional("kylin.cube.cuboid-spanning-tree", "org.apache.kylin.metadata.cube.cuboid.NForestSpanningTree");
    }

    public String getIntersectCountSeparator() {
        return this.config.getOptional("kylin.cube.intersect-count-array-separator", "|");
    }

    public boolean enableQueryPattern() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.query.favorite.collect-as-pattern", TRUE));
    }

    public boolean splitGroupSetsIntoUnion() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.query.engine.split-group-sets-into-union", TRUE));
    }

    public int defaultDecimalScale() {
        return Integer.parseInt(this.config.getOptional("kylin.query.engine.default-decimal-scale", "0"));
    }

    public boolean enablePushdownPrepareStatementWithParams() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.query.engine.push-down.enable-prepare-statement-with-params", FALSE));
    }

    public boolean runConstantQueryLocally() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.query.engine.run-constant-query-locally", TRUE));
    }

    public boolean isRecordSourceUsage() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.source.record-source-usage-enabled", TRUE));
    }

    public boolean isSourceUsageUnwrapComputedColumn() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.metadata.history-source-usage-unwrap-computed-column", TRUE));
    }

    public boolean isKerberosEnabled() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.kerberos.enabled", FALSE));
    }

    public String getKerberosKeytab() {
        return this.config.getOptional("kylin.kerberos.keytab", "");
    }

    public String getKerberosKeytabPath() {
        return KylinConfig.getKylinConfDir() + File.separator + this.getKerberosKeytab();
    }

    public String getKerberosZKPrincipal() {
        return this.config.getOptional("kylin.kerberos.zookeeper-server-principal", "zookeeper/hadoop");
    }

    public Long getKerberosTicketRefreshInterval() {
        return Long.parseLong(this.config.getOptional("kylin.kerberos.ticket-refresh-interval-minutes", "720"));
    }

    public Long getKerberosMonitorInterval() {
        return Long.parseLong(this.config.getOptional("kylin.kerberos.monitor-interval-minutes", "10"));
    }

    public Long getKerberosTGTRenewalInterval() {
        return Long.parseLong(this.config.getOptional("kylin.kerberos.tgt-renewal-interval-minutes", "10"));
    }

    public Long getKerberosTGTRetryInterval() {
        return Long.parseLong(this.config.getOptional("kylin.kerberos.tgt-retry-interval-minutes", "60"));
    }

    public String getKerberosPlatform() {
        return this.config.getOptional("kylin.kerberos.platform", "");
    }

    public boolean getPlatformZKEnable() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.env.zk-kerberos-enabled", this.config.getOptional("kylin.kerberos.enabled", FALSE)));
    }

    public String getKerberosKrb5Conf() {
        return this.config.getOptional("kylin.kerberos.krb5-conf", "krb5.conf");
    }

    public String getKerberosKrb5ConfPath() {
        return KylinConfig.getKylinConfDir() + File.separator + this.getKerberosKrb5Conf();
    }

    public String getKerberosJaasConf() {
        return this.config.getOptional("kylin.kerberos.jaas-conf", "jaas.conf");
    }

    public String getKerberosJaasConfPath() {
        return KylinConfig.getKylinConfDir() + File.separator + this.getKerberosJaasConf();
    }

    public String getKafkaJaasConf() {
        return this.config.getOptional("kylin.kafka-jaas-conf", "kafka_jaas.conf");
    }

    public String getKafkaJaasConfPath() {
        return KylinConfig.getKylinConfDir() + File.separator + this.getKafkaJaasConf();
    }

    public boolean isKafkaJaasEnabled() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.kafka-jaas.enabled", FALSE));
    }

    public String getKerberosPrincipal() {
        return this.config.getOptional("kylin.kerberos.principal");
    }

    public int getThresholdToRestartSpark() {
        return Integer.parseInt(this.config.getOptional("kylin.canary.sqlcontext-threshold-to-restart-spark", "3"));
    }

    public int getSparkCanaryErrorResponseMs() {
        return Integer.parseInt(this.config.getOptional("kylin.canary.sqlcontext-error-response-ms", "30000"));
    }

    public int getSparkCanaryPeriodMinutes() {
        return Integer.parseInt(this.config.getOptional("kylin.canary.sqlcontext-period-min", "3"));
    }

    public String getSparkCanaryType() {
        return this.config.getOptional("kylin.canary.sqlcontext-type", "file");
    }

    public boolean getSparkCanaryEnable() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.canary.sqlcontext-enabled", FALSE));
    }

    public double getJoinMemoryFraction() {
        return Double.parseDouble(this.config.getOptional("kylin.query.join-memory-fraction", "0.3"));
    }

    public int getMonitorSparkPeriodSeconds() {
        return Integer.parseInt(this.config.getOptional("kylin.storage.monitor-spark-period-seconds", "30"));
    }

    public boolean isQueryEscapedLiteral() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.query.parser.escaped-string-literals", FALSE));
    }

    public boolean isAESkewJoinEnabled() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.build.ae.skew-join-enabled", TRUE));
    }

    public boolean optimizeShardEnabled() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.build.optimize-shard-enabled", TRUE));
    }

    public boolean isAggIndexAdaptiveBuildEnabled() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.engine.aggIndex-adaptive-build-enabled", FALSE));
    }

    public String getSwitchBackupFsExceptionAllowString() {
        return this.config.getOptional("kylin.query.switch-backup-fs-exception-allow-string", "alluxio");
    }

    public boolean isQuerySparkJobTraceEnabled() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.query.spark-job-trace-enabled", TRUE));
    }

    public boolean isOnlyPlanInSparkEngine() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.query.only-plan-with-spark-engine", FALSE));
    }

    public long getSparkJobTraceTimeoutMs() {
        return Long.parseLong(this.config.getOptional("kylin.query.spark-job-trace-timeout-ms", "8000"));
    }

    public int getSparkJobTraceCacheMax() {
        return Integer.parseInt(this.config.getOptional("kylin.query.spark-job-trace-cache-max", "1000"));
    }

    public int getSparkJobTraceParallelMax() {
        return Integer.parseInt(this.config.getOptional("kylin.query.spark-job-trace-parallel-max", "50"));
    }

    public long getBigQuerySourceScanRowsThreshold() {
        return Long.parseLong(this.config.getOptional("kylin.query.big-query-source-scan-rows-threshold", "-1"));
    }

    public String getShareStateSwitchImplement() {
        return this.config.getOptional("kylin.query.share-state-switch-implement", "close");
    }

    public boolean isQueryLimitEnabled() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.query.query-limit-enabled", FALSE));
    }

    public boolean isApplyLimitInfoToSourceScanRowsEnabled() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.query.apply-limit-info-to-source-scan-rows-enabled", FALSE));
    }

    public boolean isAutoAdjustBigQueryRowsThresholdEnabled() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.query.auto-adjust-big-query-rows-threshold-enabled", FALSE));
    }

    public long getBigQuerySecond() {
        return Long.parseLong(this.config.getOptional("kylin.query.big-query-second", "10"));
    }

    public boolean isBigQueryLimitEnable() {
        return Boolean.parseBoolean(this.config.getOptional("kylin.query.big-query-limit-enabled", FALSE));
    }

    public long getBigQueryThresholdUpdateIntervalSecond() {
        return Long.parseLong(this.config.getOptional("kylin.query.big-query-threshold-update-interval-second", "10800"));
    }
}

