/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.softaffinity;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SplitLocationInfo;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.softaffinity.SoftAffinityManager;

public class SoftAffinityTextInputFormat
extends TextInputFormat {
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        org.apache.hadoop.mapred.FileSplit[] splits = (org.apache.hadoop.mapred.FileSplit[])super.getSplits(job, numSplits);
        return SoftAffinityManager.usingSoftAffinity() ? (InputSplit[])Arrays.stream(splits).map(FileSplitWithCachedLocation::new).toArray(InputSplit[]::new) : splits;
    }

    public static class FileSplitWithCachedLocation
    extends org.apache.hadoop.mapred.FileSplit {
        FileSplit selfFS;
        String[] locations;

        public FileSplitWithCachedLocation() {
            this.selfFS = new FileSplit();
            this.locations = new String[0];
        }

        public FileSplitWithCachedLocation(org.apache.hadoop.mapred.FileSplit s) {
            try {
                Field f = FieldUtils.getDeclaredField(org.apache.hadoop.mapred.FileSplit.class, (String)"fs", (boolean)true);
                this.selfFS = (FileSplit)f.get(s);
            }
            catch (Exception e) {
                throw new KylinRuntimeException((Throwable)e);
            }
            Path localityBase = s.getPath().getParent();
            this.locations = SoftAffinityManager.askExecutors(localityBase.toString());
        }

        public String[] getLocations() {
            return this.locations;
        }

        public SplitLocationInfo[] getLocationInfo() {
            return (SplitLocationInfo[])Arrays.stream(this.locations).map(l -> new SplitLocationInfo(l, false)).toArray(SplitLocationInfo[]::new);
        }

        public Path getPath() {
            return this.selfFS.getPath();
        }

        public long getStart() {
            return this.selfFS.getStart();
        }

        public long getLength() {
            return this.selfFS.getLength();
        }

        public String toString() {
            return this.selfFS.toString();
        }

        public void write(DataOutput out) throws IOException {
            this.selfFS.write(out);
        }

        public void readFields(DataInput in) throws IOException {
            this.selfFS.readFields(in);
        }
    }
}

