/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.rest.security.AclPermissionFactory;
import org.apache.kylin.rest.security.KylinAclPermissionEvaluator;
import org.apache.kylin.rest.service.AclService;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.PermissionFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Lazy
@Component(value="aclUtil")
public class AclUtil {
    String getCurrentUserName() {
        return SecurityContextHolder.getContext().getAuthentication().getName();
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')  or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT') or hasPermission(#project, 'OPERATION') or hasPermission(#project, 'READ')")
    public boolean hasProjectReadPermission(ProjectInstance project) {
        return true;
    }

    @PreAuthorize(value="hasPermission(#project, 'DATA_QUERY')")
    public boolean hasProjectDataQueryPermission(ProjectInstance project) {
        Authentication auth;
        KylinAclPermissionEvaluator evaluator;
        if (KylinConfig.getInstanceFromEnv().isUTEnv() && !(evaluator = new KylinAclPermissionEvaluator(new AclService(), (PermissionFactory)new AclPermissionFactory())).hasPermission(auth = SecurityContextHolder.getContext().getAuthentication(), project, AclPermission.DATA_QUERY)) {
            throw new AccessDeniedException("");
        }
        return true;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')  or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT') or hasPermission(#project, 'OPERATION')")
    public boolean hasProjectOperationPermission(ProjectInstance project) {
        return true;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')  or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT')")
    public boolean hasProjectWritePermission(ProjectInstance project) {
        return true;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')  or hasPermission(#project, 'ADMINISTRATION')")
    public boolean hasProjectAdminPermission(ProjectInstance project) {
        return true;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public boolean checkIsGlobalAdmin() {
        return true;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')  or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT') or (hasPermission(#project, 'OPERATION') and #isIndexEnableOperatorDesign)")
    public boolean hasProjectOperationDesignPermission(ProjectInstance project, boolean isIndexEnableOperatorDesign) {
        return true;
    }
}

