/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.system;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.ClusterConstant;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE)
public class NodeRegistry
extends RootPersistentEntity {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NodeRegistry.class);
    public static final String NODE_REGISTRY = "node_registry";
    @JsonProperty(value="name")
    private final String name = "node_registry";
    @JsonProperty(value="registry")
    private final Map<ClusterConstant.ServerModeEnum, List<NodeInstance>> registry = new HashMap<ClusterConstant.ServerModeEnum, List<NodeInstance>>();
    @JsonProperty(value="last_cleanup_ts")
    private long lastCleanupTS;

    public List<NodeInstance> getNodeInstances(ClusterConstant.ServerModeEnum mode) {
        return this.registry.getOrDefault(mode, new ArrayList());
    }

    public void registerOrUpdate(NodeInstance instance) {
        Preconditions.checkNotNull((Object)instance);
        List nodeInstances = this.registry.computeIfAbsent(instance.getServerMode(), k -> new ArrayList());
        if (nodeInstances.isEmpty()) {
            nodeInstances.add(instance);
        } else {
            int indexFound = NodeRegistry.findIndexByHostAndPort(nodeInstances, instance);
            if (indexFound > -1) {
                nodeInstances.set(indexFound, instance);
            } else {
                nodeInstances.add(instance);
            }
        }
    }

    public void deregister(NodeInstance instance) {
        int indexFound;
        Preconditions.checkNotNull((Object)instance);
        List<NodeInstance> nodeInstances = this.registry.get(instance.getServerMode());
        if (nodeInstances != null && !nodeInstances.isEmpty() && (indexFound = NodeRegistry.findIndexByHostAndPort(nodeInstances, instance)) > -1) {
            nodeInstances.remove(indexFound);
        }
    }

    public void removeExpiredRegistrations() {
        long now = System.currentTimeMillis();
        long expireThreshold = KylinConfig.getInstanceFromEnv().getNodeRegistryJdbcExpireThreshold();
        long timeoutTS = now - expireThreshold;
        for (Map.Entry<ClusterConstant.ServerModeEnum, List<NodeInstance>> entry : this.registry.entrySet()) {
            List<NodeInstance> nodeInstances = entry.getValue();
            if (nodeInstances == null || nodeInstances.isEmpty()) continue;
            nodeInstances.removeIf(node -> node.getLastHeartbeatTS() < timeoutTS);
        }
        this.lastCleanupTS = now;
    }

    public boolean isEmpty() {
        if (this.registry.isEmpty()) {
            return true;
        }
        for (List<NodeInstance> nodeInstances : this.registry.values()) {
            if (nodeInstances.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public String resourceName() {
        return NODE_REGISTRY;
    }

    public MetadataType resourceType() {
        return MetadataType.SYSTEM;
    }

    private static int findIndexByHostAndPort(List<NodeInstance> nodeInstances, NodeInstance instance) {
        for (int i = 0; i < nodeInstances.size(); ++i) {
            NodeInstance ins = nodeInstances.get(i);
            if (!ins.hostAndPortEquals(instance)) continue;
            return i;
        }
        return -1;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<ClusterConstant.ServerModeEnum, List<NodeInstance>> getRegistry() {
        return this.registry;
    }

    @Generated
    public long getLastCleanupTS() {
        return this.lastCleanupTS;
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    public static class NodeInstance {
        @JsonProperty(value="host")
        private String host;
        @JsonProperty(value="port")
        private int port;
        @JsonProperty(value="server_mode")
        private ClusterConstant.ServerModeEnum serverMode;
        @JsonProperty(value="last_heartbeat_ts")
        private long lastHeartbeatTS;

        public NodeInstance() {
        }

        public NodeInstance(String host, int port, String modeStr) {
            this(host, port, ClusterConstant.ServerModeEnum.valueOf((String)modeStr));
        }

        public NodeInstance(String host, int port, ClusterConstant.ServerModeEnum mode) {
            this.host = host;
            this.port = port;
            this.serverMode = mode;
            this.lastHeartbeatTS = System.currentTimeMillis();
        }

        public boolean hostAndPortEquals(NodeInstance that) {
            return Objects.equals(this.host, that.host) && this.port == that.port;
        }

        @Generated
        public String getHost() {
            return this.host;
        }

        @Generated
        public int getPort() {
            return this.port;
        }

        @Generated
        public ClusterConstant.ServerModeEnum getServerMode() {
            return this.serverMode;
        }

        @Generated
        public long getLastHeartbeatTS() {
            return this.lastHeartbeatTS;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NodeInstance)) {
                return false;
            }
            NodeInstance other = (NodeInstance)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            ClusterConstant.ServerModeEnum this$serverMode = this.getServerMode();
            ClusterConstant.ServerModeEnum other$serverMode = other.getServerMode();
            return !(this$serverMode == null ? other$serverMode != null : !this$serverMode.equals(other$serverMode));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NodeInstance;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            result = result * 59 + this.getPort();
            ClusterConstant.ServerModeEnum $serverMode = this.getServerMode();
            result = result * 59 + ($serverMode == null ? 43 : $serverMode.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "NodeRegistry.NodeInstance(host=" + this.getHost() + ", port=" + this.getPort() + ", serverMode=" + this.getServerMode() + ", lastHeartbeatTS=" + this.getLastHeartbeatTS() + ")";
        }
    }
}

