/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.sourceusage;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceUsageRecord
extends RootPersistentEntity {
    private static final Logger logger = LoggerFactory.getLogger(SourceUsageRecord.class);
    @JsonProperty(value="capacity_notification")
    private boolean capacityNotification = true;
    @JsonProperty(value="check_time")
    private long checkTime;
    @JsonProperty(value="current_capacity")
    private long currentCapacity;
    @JsonProperty(value="license_capacity")
    private long licenseCapacity;
    @JsonProperty(value="capacity_details")
    private transient ProjectCapacityDetail[] capacityDetails;
    @JsonProperty(value="capacity_status")
    private CapacityStatus capacityStatus = CapacityStatus.OK;
    @JsonProperty(value="res_path")
    private String resPath;

    public static Logger getLogger() {
        return logger;
    }

    public String getResourcePath() {
        return this.resPath;
    }

    public String resourceName() {
        if (this.resPath != null) {
            return this.resPath.substring(MetadataType.HISTORY_SOURCE_USAGE.name().length() + 1);
        }
        return null;
    }

    public SourceUsageRecord() {
        this.capacityDetails = new ProjectCapacityDetail[0];
    }

    public void appendProject(ProjectCapacityDetail project) {
        ArrayList allProject = Lists.newArrayList((Object[])this.capacityDetails);
        allProject.add(project);
        this.capacityDetails = allProject.toArray(new ProjectCapacityDetail[0]);
    }

    public ProjectCapacityDetail getProjectCapacity(String name) {
        for (ProjectCapacityDetail c : this.capacityDetails) {
            if (!name.equals(c.getName())) continue;
            return c;
        }
        return null;
    }

    @Generated
    public boolean isCapacityNotification() {
        return this.capacityNotification;
    }

    @Generated
    public long getCheckTime() {
        return this.checkTime;
    }

    @Generated
    public long getCurrentCapacity() {
        return this.currentCapacity;
    }

    @Generated
    public long getLicenseCapacity() {
        return this.licenseCapacity;
    }

    @Generated
    public ProjectCapacityDetail[] getCapacityDetails() {
        return this.capacityDetails;
    }

    @Generated
    public CapacityStatus getCapacityStatus() {
        return this.capacityStatus;
    }

    @Generated
    public String getResPath() {
        return this.resPath;
    }

    @Generated
    public void setCapacityNotification(boolean capacityNotification) {
        this.capacityNotification = capacityNotification;
    }

    @Generated
    public void setCheckTime(long checkTime) {
        this.checkTime = checkTime;
    }

    @Generated
    public void setCurrentCapacity(long currentCapacity) {
        this.currentCapacity = currentCapacity;
    }

    @Generated
    public void setLicenseCapacity(long licenseCapacity) {
        this.licenseCapacity = licenseCapacity;
    }

    @Generated
    public void setCapacityDetails(ProjectCapacityDetail[] capacityDetails) {
        this.capacityDetails = capacityDetails;
    }

    @Generated
    public void setCapacityStatus(CapacityStatus capacityStatus) {
        this.capacityStatus = capacityStatus;
    }

    @Generated
    public void setResPath(String resPath) {
        this.resPath = resPath;
    }

    @Generated
    public String toString() {
        return "SourceUsageRecord(capacityNotification=" + this.isCapacityNotification() + ", checkTime=" + this.getCheckTime() + ", currentCapacity=" + this.getCurrentCapacity() + ", licenseCapacity=" + this.getLicenseCapacity() + ", capacityDetails=" + Arrays.deepToString(this.getCapacityDetails()) + ", capacityStatus=" + (Object)((Object)this.getCapacityStatus()) + ", resPath=" + this.getResPath() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceUsageRecord)) {
            return false;
        }
        SourceUsageRecord other = (SourceUsageRecord)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isCapacityNotification() != other.isCapacityNotification()) {
            return false;
        }
        if (this.getCheckTime() != other.getCheckTime()) {
            return false;
        }
        if (this.getCurrentCapacity() != other.getCurrentCapacity()) {
            return false;
        }
        if (this.getLicenseCapacity() != other.getLicenseCapacity()) {
            return false;
        }
        CapacityStatus this$capacityStatus = this.getCapacityStatus();
        CapacityStatus other$capacityStatus = other.getCapacityStatus();
        if (this$capacityStatus == null ? other$capacityStatus != null : !((Object)((Object)this$capacityStatus)).equals((Object)other$capacityStatus)) {
            return false;
        }
        String this$resPath = this.getResPath();
        String other$resPath = other.getResPath();
        return !(this$resPath == null ? other$resPath != null : !this$resPath.equals(other$resPath));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SourceUsageRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCapacityNotification() ? 79 : 97);
        long $checkTime = this.getCheckTime();
        result = result * 59 + (int)($checkTime >>> 32 ^ $checkTime);
        long $currentCapacity = this.getCurrentCapacity();
        result = result * 59 + (int)($currentCapacity >>> 32 ^ $currentCapacity);
        long $licenseCapacity = this.getLicenseCapacity();
        result = result * 59 + (int)($licenseCapacity >>> 32 ^ $licenseCapacity);
        CapacityStatus $capacityStatus = this.getCapacityStatus();
        result = result * 59 + ($capacityStatus == null ? 43 : ((Object)((Object)$capacityStatus)).hashCode());
        String $resPath = this.getResPath();
        result = result * 59 + ($resPath == null ? 43 : $resPath.hashCode());
        return result;
    }

    public static enum CapacityStatus {
        OK,
        TENTATIVE,
        ERROR,
        OVERCAPACITY;

    }

    public static enum TableKind {
        FACT,
        WITHSNAP,
        WITHOUTSNAP;

    }

    public static class ColumnCapacityDetail {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="max_source_bytes")
        private long maxSourceBytes = 0L;
        @JsonProperty(value="source_bytes_map")
        private Map<String, Long> sourceBytesMap = new HashMap<String, Long>();

        public ColumnCapacityDetail() {
        }

        public ColumnCapacityDetail(ColumnCapacityDetail other) {
            this.name = other.name;
            this.maxSourceBytes = other.maxSourceBytes;
            this.sourceBytesMap = other.sourceBytesMap;
        }

        public ColumnCapacityDetail(String name) {
            this.name = name;
        }

        public long getDataflowSourceBytes(String dataflow) {
            return this.sourceBytesMap.get(dataflow);
        }

        public void setDataflowSourceBytes(String dataflow, long sourceBytes) {
            this.sourceBytesMap.put(dataflow, sourceBytes);
            this.maxSourceBytes = Long.max(this.maxSourceBytes, sourceBytes);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public long getMaxSourceBytes() {
            return this.maxSourceBytes;
        }

        @Generated
        public Map<String, Long> getSourceBytesMap() {
            return this.sourceBytesMap;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setMaxSourceBytes(long maxSourceBytes) {
            this.maxSourceBytes = maxSourceBytes;
        }

        @Generated
        public void setSourceBytesMap(Map<String, Long> sourceBytesMap) {
            this.sourceBytesMap = sourceBytesMap;
        }
    }

    public static class TableCapacityDetail {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="status")
        private CapacityStatus status = CapacityStatus.OK;
        @JsonProperty(value="capacity")
        private long capacity;
        @JsonProperty(value="capacity_ratio")
        private double capacityRatio;
        @JsonProperty(value="table_type")
        private TableKind tableKind;
        @JsonProperty(value="columns")
        private ColumnCapacityDetail[] columns;

        public TableCapacityDetail() {
        }

        public TableCapacityDetail(TableCapacityDetail other) {
            this.name = other.name;
            this.status = other.status;
            this.tableKind = other.tableKind;
            this.capacity = other.capacity;
            this.capacityRatio = other.capacityRatio;
            this.columns = new ColumnCapacityDetail[other.columns.length];
            for (int i = 0; i < other.columns.length; ++i) {
                this.columns[i] = new ColumnCapacityDetail(other.columns[i]);
            }
        }

        public TableCapacityDetail(String name) {
            this.name = name;
            this.columns = new ColumnCapacityDetail[0];
        }

        public void appendColumn(ColumnCapacityDetail column) {
            ArrayList allColumns = Lists.newArrayList((Object[])this.columns);
            allColumns.add(column);
            this.columns = allColumns.toArray(new ColumnCapacityDetail[0]);
        }

        public ColumnCapacityDetail getColumnByName(String name) {
            for (ColumnCapacityDetail c : this.columns) {
                if (!name.equalsIgnoreCase(c.getName())) continue;
                return c;
            }
            return null;
        }

        public void updateColumn(ColumnCapacityDetail column) {
            ColumnCapacityDetail existing = this.getColumnByName(column.name);
            if (existing == null) {
                this.appendColumn(column);
            }
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public CapacityStatus getStatus() {
            return this.status;
        }

        @Generated
        public long getCapacity() {
            return this.capacity;
        }

        @Generated
        public double getCapacityRatio() {
            return this.capacityRatio;
        }

        @Generated
        public TableKind getTableKind() {
            return this.tableKind;
        }

        @Generated
        public ColumnCapacityDetail[] getColumns() {
            return this.columns;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setStatus(CapacityStatus status) {
            this.status = status;
        }

        @Generated
        public void setCapacity(long capacity) {
            this.capacity = capacity;
        }

        @Generated
        public void setCapacityRatio(double capacityRatio) {
            this.capacityRatio = capacityRatio;
        }

        @Generated
        public void setTableKind(TableKind tableKind) {
            this.tableKind = tableKind;
        }

        @Generated
        public void setColumns(ColumnCapacityDetail[] columns) {
            this.columns = columns;
        }
    }

    public static class ProjectCapacityDetail {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="capacity")
        private long capacity;
        @JsonProperty(value="license_capacity")
        private long licenseCapacity;
        @JsonProperty(value="capacity_ratio")
        private double capacityRatio;
        @JsonProperty(value="status")
        private CapacityStatus status = CapacityStatus.OK;
        @JsonProperty(value="tables")
        private TableCapacityDetail[] tables;

        public ProjectCapacityDetail() {
        }

        public ProjectCapacityDetail(ProjectCapacityDetail projectCapacity) {
            this.name = projectCapacity.name;
            this.capacity = projectCapacity.capacity;
            this.status = projectCapacity.status;
            this.capacityRatio = projectCapacity.capacityRatio;
            this.tables = new TableCapacityDetail[projectCapacity.tables.length];
            for (int i = 0; i < projectCapacity.tables.length; ++i) {
                this.tables[i] = new TableCapacityDetail(projectCapacity.tables[i]);
            }
        }

        public ProjectCapacityDetail(String name) {
            this.name = name;
            this.tables = new TableCapacityDetail[0];
        }

        public void appendTable(TableCapacityDetail table) {
            ArrayList allTables = Lists.newArrayList((Object[])this.tables);
            allTables.add(table);
            this.tables = allTables.toArray(new TableCapacityDetail[0]);
        }

        public TableCapacityDetail getTableByName(String name) {
            for (TableCapacityDetail c : this.tables) {
                if (!name.equalsIgnoreCase(c.getName())) continue;
                return c;
            }
            return null;
        }

        public void updateTable(TableCapacityDetail table) {
            TableCapacityDetail existing = this.getTableByName(table.name);
            if (existing == null) {
                this.appendTable(table);
            }
        }

        public boolean isOverCapacity() {
            return this.status == CapacityStatus.OVERCAPACITY;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public long getCapacity() {
            return this.capacity;
        }

        @Generated
        public long getLicenseCapacity() {
            return this.licenseCapacity;
        }

        @Generated
        public double getCapacityRatio() {
            return this.capacityRatio;
        }

        @Generated
        public CapacityStatus getStatus() {
            return this.status;
        }

        @Generated
        public TableCapacityDetail[] getTables() {
            return this.tables;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setCapacity(long capacity) {
            this.capacity = capacity;
        }

        @Generated
        public void setLicenseCapacity(long licenseCapacity) {
            this.licenseCapacity = licenseCapacity;
        }

        @Generated
        public void setCapacityRatio(double capacityRatio) {
            this.capacityRatio = capacityRatio;
        }

        @Generated
        public void setStatus(CapacityStatus status) {
            this.status = status;
        }

        @Generated
        public void setTables(TableCapacityDetail[] tables) {
            this.tables = tables;
        }
    }
}

