/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.schema;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.schema.ImportModelContext;
import org.apache.kylin.metadata.model.schema.SchemaChangeCheckResult;
import org.apache.kylin.metadata.model.schema.SchemaUtil;
import org.apache.kylin.metadata.model.schema.strategy.ComputedColumnStrategy;
import org.apache.kylin.metadata.model.schema.strategy.MultiplePartitionStrategy;
import org.apache.kylin.metadata.model.schema.strategy.OverWritableStrategy;
import org.apache.kylin.metadata.model.schema.strategy.SchemaChangeStrategy;
import org.apache.kylin.metadata.model.schema.strategy.TableColumnStrategy;
import org.apache.kylin.metadata.model.schema.strategy.TableStrategy;
import org.apache.kylin.metadata.model.schema.strategy.UnOverWritableStrategy;

public final class ModelImportChecker {
    private static final List<SchemaChangeStrategy> strategies = Arrays.asList(new ComputedColumnStrategy(), new UnOverWritableStrategy(), new TableColumnStrategy(), new TableStrategy(), new OverWritableStrategy(), new MultiplePartitionStrategy());

    public static SchemaChangeCheckResult check(SchemaUtil.SchemaDifference diff, ImportModelContext context) {
        String targetProject = context.getTargetProject();
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        Set<String> importModels = NDataModelManager.getInstance(context.getImportKylinConfig(), targetProject).listAllModelAlias().stream().map(model -> context.getNewModels().getOrDefault(model, (String)model)).collect(Collectors.toSet());
        Set<String> originalModels = NDataModelManager.getInstance(kylinConfig, targetProject).listAllModelAlias();
        Set<String> originBrokenModels = NDataflowManager.getInstance(kylinConfig, targetProject).listAllDataflows(true).stream().filter(NDataflow::checkBrokenWithRelatedInfo).map(df -> df.getModel().getAlias()).collect(Collectors.toSet());
        SchemaChangeCheckResult result = new SchemaChangeCheckResult();
        for (SchemaChangeStrategy strategy : strategies) {
            result.addMissingItems(strategy.missingItems(diff, importModels, originalModels, originBrokenModels));
            result.addNewItems(strategy.newItems(diff, importModels, originalModels, originBrokenModels));
            result.addReduceItems(strategy.reduceItems(diff, importModels, originalModels, originBrokenModels));
            result.addUpdateItems(strategy.updateItems(diff, importModels, originalModels, originBrokenModels));
            result.areEqual(strategy.areEqual(diff, importModels));
        }
        return result;
    }

    @Generated
    private ModelImportChecker() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

