/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;

public class TblColRef
implements Serializable {
    private static final String INNER_TABLE_NAME = "_kylin_table";
    private static final String BACK_TICK = Quoting.BACK_TICK.string;
    private static final String DOUBLE_QUOTE = Quoting.DOUBLE_QUOTE.string;
    public static final String DYNAMIC_DATA_TYPE = "_dynamic_type";
    public static final String UNKNOWN_ALIAS = "UNKNOWN_ALIAS";
    private static final NDataModel UNKNOWN_MODEL = new NDataModel();
    private TableRef table;
    private TableRef backupTable;
    private ColumnDesc column;
    private String identity;
    private String parserDescription;
    private FilterColEnum filterLevel = FilterColEnum.NONE;
    private transient SqlOperator operator;
    private List<TblColRef> operands;

    public static TblColRef newInnerColumn(String columnName, InnerDataTypeEnum dataType) {
        return TblColRef.newInnerColumn(columnName, dataType, null);
    }

    public static TblColRef newInnerColumn(String columnName, InnerDataTypeEnum dataType, String parserDescription) {
        return TblColRef.newInnerColumn(columnName, dataType, parserDescription, null, null);
    }

    public static TblColRef newInnerColumn(String columnName, InnerDataTypeEnum dataType, String parserDescription, SqlOperator operator, List<TblColRef> opreands) {
        ColumnDesc column = new ColumnDesc();
        column.setName(columnName);
        TableDesc table = new TableDesc();
        column.setTable(table);
        TblColRef colRef = new TblColRef(column);
        colRef.markInnerColumn(dataType);
        colRef.parserDescription = parserDescription;
        colRef.setOperator(operator);
        colRef.setOperands(opreands);
        return colRef;
    }

    public static TblColRef newDynamicColumn(String columnName) {
        ColumnDesc column = new ColumnDesc();
        column.setName(columnName);
        column.setDatatype(DYNAMIC_DATA_TYPE);
        TableDesc table = new TableDesc();
        column.setTable(table);
        return new TblColRef(column);
    }

    public static TableRef tableForUnknownModel(String tempTableAlias, TableDesc table) {
        return new TableRef(UNKNOWN_MODEL, tempTableAlias, table, false);
    }

    public static TblColRef columnForUnknownModel(TableRef table, ColumnDesc colDesc) {
        Preconditions.checkArgument((table.getModel() == UNKNOWN_MODEL ? 1 : 0) != 0);
        return new TblColRef(table, colDesc);
    }

    public static void fixUnknownModel(NDataModel model, String alias, TblColRef col) {
        Preconditions.checkArgument((col.table.getModel() == UNKNOWN_MODEL || col.table.getModel() == model ? 1 : 0) != 0);
        TableRef tableRef = model.findTable(alias);
        Preconditions.checkArgument((boolean)tableRef.getTableDesc().getIdentity().equals(col.column.getTable().getIdentity()));
        col.fixTableRef(tableRef);
    }

    public static void unfixUnknownModel(TblColRef col) {
        col.unfixTableRef();
    }

    public static TblColRef mockup(TableDesc table, int oneBasedColumnIndex, String name, String datatype) {
        return TblColRef.mockup(table, oneBasedColumnIndex, name, datatype, null);
    }

    public static TblColRef mockup(TableDesc table, int oneBasedColumnIndex, String name, String datatype, String computedColumnExpr) {
        return TblColRef.mockup(table, oneBasedColumnIndex, name, datatype, null, computedColumnExpr);
    }

    public static TblColRef mockup(TableDesc table, int oneBasedColumnIndex, String name, String datatype, String comment, String computedColumnExpr) {
        String id = "" + oneBasedColumnIndex;
        ColumnDesc desc = new ColumnDesc(id, name, datatype, comment, null, null, computedColumnExpr);
        desc.init(table);
        return new TblColRef(desc);
    }

    TblColRef(ColumnDesc column) {
        this.column = column;
    }

    public TblColRef(TableRef table, ColumnDesc column) {
        Preconditions.checkArgument((boolean)table.getTableDesc().getIdentity().equals(column.getTable().getIdentity()));
        this.table = table;
        this.column = column;
    }

    private String wrapIdentity(String wrap) {
        return wrap + this.getTableAlias() + wrap + "." + wrap + this.getName() + wrap;
    }

    public void fixTableRef(TableRef tableRef) {
        this.backupTable = this.table;
        this.table = tableRef;
        this.identity = null;
    }

    public ColumnDesc getColumnDesc() {
        return this.column;
    }

    public void unfixTableRef() {
        this.table = this.backupTable;
        this.identity = null;
    }

    public String getOriginalName() {
        return this.column.getOriginalName();
    }

    public String getName() {
        return this.column.getName();
    }

    public TableRef getTableRef() {
        return this.table;
    }

    public boolean isQualified() {
        return this.table != null;
    }

    public String getTableAlias() {
        return this.table != null ? this.table.getAlias() : UNKNOWN_ALIAS;
    }

    public String getExpressionInSourceDB() {
        if (!this.column.isComputedColumn()) {
            return this.getIdentity();
        }
        return this.column.getComputedColumnExpr();
    }

    public String getDoubleQuoteExp() {
        if (this.column.isComputedColumn()) {
            return this.column.getDoubleQuoteInnerExpr();
        }
        return this.wrapIdentity(DOUBLE_QUOTE);
    }

    public String getBackTickExp() {
        return this.column.isComputedColumn() ? this.column.getComputedColumnExpr() : this.wrapIdentity(BACK_TICK);
    }

    public String getTable() {
        if (this.column.getTable() == null) {
            return null;
        }
        return this.column.getTable().getIdentity();
    }

    public String getAliasDotName() {
        return this.getTableAlias() + "." + this.getName();
    }

    public String getTableAliasColName() {
        return this.table == null ? null : String.format(Locale.ROOT, "%s.%s.%s", this.table.getTableDesc().getDatabase(), this.getTableAlias(), this.getName());
    }

    public String getTableDotName() {
        return this.column.getTable().getName() + "." + this.getName();
    }

    public String getCanonicalName() {
        return this.column.getCanonicalName();
    }

    public String getDatatype() {
        return this.column.getDatatype();
    }

    public DataType getType() {
        return this.column.getType();
    }

    public String getParserDescription() {
        return this.parserDescription;
    }

    private void markInnerColumn(InnerDataTypeEnum dataType) {
        this.column.setDatatype(dataType.getDataType());
        this.column.getTable().setName(INNER_TABLE_NAME);
        this.column.getTable().setDatabase("DEFAULT");
    }

    public boolean isInnerColumn() {
        return InnerDataTypeEnum.contains(this.getDatatype());
    }

    public boolean isAggregationColumn() {
        return InnerDataTypeEnum.isAggregationType(this.getDatatype());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column.getTable().getIdentity().hashCode();
        result = 31 * result + this.column.getName().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TblColRef other = (TblColRef)obj;
        if (!StringUtils.equals((CharSequence)this.column.getTable().getIdentity(), (CharSequence)other.column.getTable().getIdentity())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)this.column.getName(), (CharSequence)other.column.getName())) {
            return false;
        }
        if (!Objects.equals(this.table, other.table)) {
            return false;
        }
        if (this.backupTable != null && other.backupTable != null && !this.backupTable.equals(other.backupTable)) {
            return false;
        }
        return this.isInnerColumn() == other.isInnerColumn();
    }

    public String getIdentity() {
        if (this.identity == null) {
            this.identity = this.getTableAlias() + "." + this.getName();
        }
        return this.identity;
    }

    public String getBackTickIdentity() {
        return this.wrapIdentity(BACK_TICK);
    }

    public String toString() {
        String tableIdentity;
        if (this.isInnerColumn() && this.parserDescription != null) {
            return this.parserDescription;
        }
        String alias = this.table == null ? "UNKNOWN_MODEL" : this.table.getAlias();
        String tableName = this.column.getTable() == null ? "NULL" : this.column.getTable().getName();
        String string = tableIdentity = this.column.getTable() == null ? "NULL" : this.column.getTable().getIdentity();
        if (alias.equals(tableName)) {
            return tableIdentity + "." + this.column.getName();
        }
        return alias + ":" + tableIdentity + "." + this.column.getName();
    }

    public String getTableWithSchema() {
        if (this.isInnerColumn() && this.parserDescription != null) {
            return this.parserDescription;
        }
        if (this.column.getTable() == null) {
            return "NULL";
        }
        return StringUtils.upperCase((String)this.column.getTable().getIdentity());
    }

    public String getColumnWithTableAndSchema() {
        return StringUtils.upperCase((String)(this.getTableWithSchema() + "." + this.column.getName()));
    }

    public boolean isCastInnerColumn() {
        return this.isInnerColumn() && this.getOperator() != null && this.getOperator().kind == SqlKind.CAST;
    }

    public static void collectSourceColumns(TblColRef colRef, Set<TblColRef> collector) {
        boolean innerColumn = colRef.isInnerColumn();
        if (!innerColumn) {
            collector.add(colRef);
            return;
        }
        if (colRef.getOperands() == null) {
            return;
        }
        for (TblColRef child : colRef.getOperands()) {
            TblColRef.collectSourceColumns(child, collector);
        }
    }

    public Set<TblColRef> getSourceColumns() {
        HashSet<TblColRef> resultSet = new HashSet<TblColRef>();
        TblColRef.collectSourceColumns(this, resultSet);
        return resultSet;
    }

    @Generated
    public FilterColEnum getFilterLevel() {
        return this.filterLevel;
    }

    @Generated
    public void setFilterLevel(FilterColEnum filterLevel) {
        this.filterLevel = filterLevel;
    }

    @Generated
    public void setOperator(SqlOperator operator) {
        this.operator = operator;
    }

    @Generated
    public SqlOperator getOperator() {
        return this.operator;
    }

    @Generated
    public void setOperands(List<TblColRef> operands) {
        this.operands = operands;
    }

    @Generated
    public List<TblColRef> getOperands() {
        return this.operands;
    }

    static {
        UNKNOWN_MODEL.setAlias("UNKNOWN_MODEL");
    }

    public static enum FilterColEnum {
        EQUAL_FILTER("equal_filter", 5),
        INFERIOR_EQUAL_FILTER("inferior_equal_filter", 4),
        RANGE_FILTER("range_filter", 3),
        LIKE_FILTER("like_filter", 2),
        OTHER_FILTER("other_filter", 1),
        NONE("none", 0);

        private final String filterLevel;
        private final int priority;

        private FilterColEnum(String filterLevel, int priority) {
            this.filterLevel = filterLevel;
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }
    }

    public static enum InnerDataTypeEnum {
        LITERAL("_literal_type"),
        DERIVED("_derived_type"),
        AGGREGATION_TYPE("_aggregation_type");

        private final String dateType;

        private InnerDataTypeEnum(String name) {
            this.dateType = name;
        }

        public String getDataType() {
            return this.dateType;
        }

        public static boolean contains(String name) {
            return LITERAL.getDataType().equals(name) || DERIVED.getDataType().equals(name) || AGGREGATION_TYPE.getDataType().equals(name);
        }

        public static boolean isAggregationType(String name) {
            return AGGREGATION_TYPE.getDataType().equals(name);
        }
    }
}

