/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.util.MultiPartitionUtil;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class MultiPartitionDesc
implements Serializable {
    @JsonProperty(value="columns")
    private LinkedList<String> columns;
    @JsonProperty(value="partitions")
    private List<PartitionInfo> partitions = new ArrayList<PartitionInfo>();
    private String partitionConditionBuilderClz = DefaultMultiPartitionConditionBuilder.class.getName();
    @JsonProperty(value="max_partition_id")
    private long maxPartitionID = -1L;
    private LinkedList<TblColRef> columnRefs = Lists.newLinkedList();
    private Map<Long, PartitionInfo> partitionInfoMap = Maps.newHashMap();
    private PartitionDesc.IPartitionConditionBuilder partitionConditionBuilder;

    public void init(NDataModel model) {
        if (CollectionUtils.isEmpty(this.columns)) {
            return;
        }
        for (String columnDesc : this.columns) {
            this.columnRefs.add(model.findColumn(columnDesc));
        }
        this.initPartitionMap();
        this.partitionConditionBuilder = (PartitionDesc.IPartitionConditionBuilder)ClassUtil.newInstance((String)this.partitionConditionBuilderClz);
    }

    public void initPartitionMap() {
        this.partitionInfoMap = this.partitions.stream().collect(Collectors.toMap(PartitionInfo::getId, partition -> partition));
    }

    public void removePartitionValue(List<Long> toBeDeletedPartIds) {
        if (CollectionUtils.isEmpty(toBeDeletedPartIds)) {
            return;
        }
        HashSet<Long> toBeDeletedPartIdSet = new HashSet<Long>(toBeDeletedPartIds);
        this.partitions.removeIf(partitionInfo -> toBeDeletedPartIdSet.contains(partitionInfo.getId()));
    }

    public PartitionInfo getPartitionByValue(String[] newValue) {
        Preconditions.checkState((newValue.length == this.columns.size() ? 1 : 0) != 0);
        for (int i = 0; i < this.partitions.size(); ++i) {
            PartitionInfo partition = this.partitions.get(i);
            if (!MultiPartitionUtil.isSameValue(partition.getValues(), newValue)) continue;
            return partition;
        }
        return null;
    }

    public Set<Long> getPartitionIdsByValues(List<String[]> subPartitionValues) {
        HashSet partitionIds = Sets.newHashSet();
        if (subPartitionValues == null) {
            return partitionIds;
        }
        subPartitionValues.forEach(partition -> {
            PartitionInfo partitionInfo = this.getPartitionByValue((String[])partition);
            if (partitionInfo != null) {
                partitionIds.add(partitionInfo.getId());
            }
        });
        return partitionIds;
    }

    public PartitionInfo getPartitionInfo(long id) {
        return this.partitionInfoMap.get(id);
    }

    public List<String[]> getPartitionValuesById(List<Long> partitionId) {
        if (MapUtils.isEmpty(this.partitionInfoMap)) {
            this.initPartitionMap();
        }
        ArrayList partValues = Lists.newArrayList();
        partitionId.forEach(id -> {
            Preconditions.checkNotNull((Object)this.partitionInfoMap.get(id));
            partValues.add(this.partitionInfoMap.get(id).getValues());
        });
        return partValues;
    }

    public PartitionDesc.IPartitionConditionBuilder getPartitionConditionBuilder() {
        return this.partitionConditionBuilder;
    }

    public static String generateFormattedValue(DataType dataType, String value) {
        if (dataType.isBoolean()) {
            return String.format(Locale.ROOT, "cast('%s' as boolean)", value);
        }
        return String.format(Locale.ROOT, "'%s'", value);
    }

    public MultiPartitionDesc(LinkedList<String> columns) {
        this.columns = columns;
    }

    @Generated
    public LinkedList<String> getColumns() {
        return this.columns;
    }

    @Generated
    public List<PartitionInfo> getPartitions() {
        return this.partitions;
    }

    @Generated
    public String getPartitionConditionBuilderClz() {
        return this.partitionConditionBuilderClz;
    }

    @Generated
    public long getMaxPartitionID() {
        return this.maxPartitionID;
    }

    @Generated
    public LinkedList<TblColRef> getColumnRefs() {
        return this.columnRefs;
    }

    @Generated
    public Map<Long, PartitionInfo> getPartitionInfoMap() {
        return this.partitionInfoMap;
    }

    @Generated
    public void setColumns(LinkedList<String> columns) {
        this.columns = columns;
    }

    @Generated
    public void setPartitions(List<PartitionInfo> partitions) {
        this.partitions = partitions;
    }

    @Generated
    public void setPartitionConditionBuilderClz(String partitionConditionBuilderClz) {
        this.partitionConditionBuilderClz = partitionConditionBuilderClz;
    }

    @Generated
    public void setColumnRefs(LinkedList<TblColRef> columnRefs) {
        this.columnRefs = columnRefs;
    }

    @Generated
    public void setPartitionInfoMap(Map<Long, PartitionInfo> partitionInfoMap) {
        this.partitionInfoMap = partitionInfoMap;
    }

    @Generated
    public void setPartitionConditionBuilder(PartitionDesc.IPartitionConditionBuilder partitionConditionBuilder) {
        this.partitionConditionBuilder = partitionConditionBuilder;
    }

    @Generated
    public MultiPartitionDesc() {
    }

    @Generated
    public MultiPartitionDesc(LinkedList<String> columns, List<PartitionInfo> partitions, String partitionConditionBuilderClz, long maxPartitionID, LinkedList<TblColRef> columnRefs, Map<Long, PartitionInfo> partitionInfoMap, PartitionDesc.IPartitionConditionBuilder partitionConditionBuilder) {
        this.columns = columns;
        this.partitions = partitions;
        this.partitionConditionBuilderClz = partitionConditionBuilderClz;
        this.maxPartitionID = maxPartitionID;
        this.columnRefs = columnRefs;
        this.partitionInfoMap = partitionInfoMap;
        this.partitionConditionBuilder = partitionConditionBuilder;
    }

    @Generated
    public void setMaxPartitionID(long maxPartitionID) {
        this.maxPartitionID = maxPartitionID;
    }

    public static class PartitionInfo
    implements Serializable {
        private long id;
        private String[] values;

        @Generated
        public long getId() {
            return this.id;
        }

        @Generated
        public String[] getValues() {
            return this.values;
        }

        @Generated
        public void setId(long id) {
            this.id = id;
        }

        @Generated
        public void setValues(String[] values) {
            this.values = values;
        }

        @Generated
        public String toString() {
            return "MultiPartitionDesc.PartitionInfo(id=" + this.getId() + ", values=" + Arrays.deepToString(this.getValues()) + ")";
        }

        @Generated
        public PartitionInfo(long id, String[] values) {
            this.id = id;
            this.values = values;
        }

        @Generated
        public PartitionInfo() {
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PartitionInfo)) {
                return false;
            }
            PartitionInfo other = (PartitionInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Arrays.deepEquals(this.getValues(), other.getValues());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PartitionInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getValues());
            return result;
        }
    }

    public static class DefaultMultiPartitionConditionBuilder
    implements PartitionDesc.IPartitionConditionBuilder,
    Serializable {
        @Override
        public String buildDateRangeCondition(PartitionDesc partDesc, ISegment seg, SegmentRange segRange) {
            PartitionDesc.IPartitionConditionBuilder builder = partDesc.getPartitionConditionBuilder();
            return builder.buildDateRangeCondition(partDesc, seg, segRange);
        }

        @Override
        public String buildMultiPartitionCondition(PartitionDesc partDesc, MultiPartitionDesc multiPartDesc, LinkedList<Long> partitionIds, ISegment seg, SegmentRange segRange) {
            String mlpCondition;
            String timeRange = PartitionDesc.isEmptyPartitionDesc(partDesc) || Objects.isNull(segRange) || segRange.isInfinite() ? null : this.buildDateRangeCondition(partDesc, seg, segRange);
            if (Objects.isNull(timeRange) && CollectionUtils.isEmpty(partitionIds)) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            if (Objects.nonNull(timeRange)) {
                builder.append(timeRange);
            }
            if (Objects.nonNull(mlpCondition = DefaultMultiPartitionConditionBuilder.buildMLPCondition(multiPartDesc, seg, partitionIds))) {
                builder.append(" and ").append(mlpCondition);
            }
            return builder.toString();
        }

        public static String buildMLPCondition(MultiPartitionDesc multiPartDesc, ISegment seg, List<Long> partitionIDs) {
            if (CollectionUtils.isEmpty(partitionIDs)) {
                return null;
            }
            LinkedList<TblColRef> columnRefs = multiPartDesc.getColumnRefs();
            List values = partitionIDs.stream().map(multiPartDesc::getPartitionInfo).map(PartitionInfo::getValues).collect(Collectors.toList());
            ArrayList conditions = Lists.newArrayList();
            int i = 0;
            while (i < columnRefs.size()) {
                int x = i++;
                String item = ((TblColRef)columnRefs.get(x)).getBackTickExp() + " in (" + values.stream().map(a -> MultiPartitionDesc.generateFormattedValue(((TblColRef)columnRefs.get(x)).getType(), a[x])).collect(Collectors.joining(", ")) + ")";
                conditions.add(item);
            }
            return String.join((CharSequence)" and ", conditions);
        }
    }
}

