/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.ModelJoinRelationTypeEnum;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class JoinTableDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FLATTEN = "flatten";
    public static final String NORMALIZED = "normalized";
    @JsonProperty(value="table")
    private String table;
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private NDataModel.TableKind kind = NDataModel.TableKind.LOOKUP;
    @JsonProperty(value="alias")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String alias;
    @JsonProperty(value="join")
    private JoinDesc join;
    @JsonProperty(value="flattenable")
    private String flattenable;
    @JsonProperty(value="join_relation_type")
    private ModelJoinRelationTypeEnum joinRelationTypeEnum = ModelJoinRelationTypeEnum.MANY_TO_ONE;
    private TableRef tableRef;

    public boolean isFlattenable() {
        return !NORMALIZED.equalsIgnoreCase(this.flattenable);
    }

    public boolean isDerivedForbidden() {
        return this.isFlattenable() && this.isToManyJoinRelation();
    }

    public boolean isToManyJoinRelation() {
        return this.joinRelationTypeEnum == ModelJoinRelationTypeEnum.MANY_TO_MANY || this.joinRelationTypeEnum == ModelJoinRelationTypeEnum.ONE_TO_MANY;
    }

    public boolean isDerivedToManyJoinRelation() {
        return !this.isFlattenable() && this.isToManyJoinRelation();
    }

    public boolean hasDifferentAntiFlattenable(JoinTableDesc other) {
        return this.isFlattenable() ^ other.isFlattenable();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinTableDesc that = (JoinTableDesc)o;
        if (this.table != null ? !this.table.equals(that.table) : that.table != null) {
            return false;
        }
        if (this.kind != that.kind) {
            return false;
        }
        if (this.alias != null ? !this.alias.equals(that.alias) : that.alias != null) {
            return false;
        }
        if (!Objects.equals((Object)this.joinRelationTypeEnum, (Object)that.joinRelationTypeEnum)) {
            return false;
        }
        return this.join != null ? this.join.equals(that.join) : that.join == null;
    }

    public int hashCode() {
        int result = this.table != null ? this.table.hashCode() : 0;
        result = 31 * result + (this.kind != null ? this.kind.hashCode() : 0);
        result = 31 * result + (this.alias != null ? this.alias.hashCode() : 0);
        result = 31 * result + (this.join != null ? this.join.hashCode() : 0);
        result = 31 * result + Objects.hashCode((Object)this.joinRelationTypeEnum);
        return result;
    }

    @Generated
    public String getTable() {
        return this.table;
    }

    @Generated
    public NDataModel.TableKind getKind() {
        return this.kind;
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Generated
    public JoinDesc getJoin() {
        return this.join;
    }

    @Generated
    public String getFlattenable() {
        return this.flattenable;
    }

    @Generated
    public ModelJoinRelationTypeEnum getJoinRelationTypeEnum() {
        return this.joinRelationTypeEnum;
    }

    @Generated
    public TableRef getTableRef() {
        return this.tableRef;
    }

    @Generated
    public void setTable(String table) {
        this.table = table;
    }

    @Generated
    public void setKind(NDataModel.TableKind kind) {
        this.kind = kind;
    }

    @Generated
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Generated
    public void setJoin(JoinDesc join) {
        this.join = join;
    }

    @Generated
    public void setFlattenable(String flattenable) {
        this.flattenable = flattenable;
    }

    @Generated
    public void setJoinRelationTypeEnum(ModelJoinRelationTypeEnum joinRelationTypeEnum) {
        this.joinRelationTypeEnum = joinRelationTypeEnum;
    }

    @Generated
    public void setTableRef(TableRef tableRef) {
        this.tableRef = tableRef;
    }
}

