/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class DataCheckDesc
implements Serializable {
    @JsonProperty(value="check_options")
    private long checkOptions;
    @JsonProperty(value="fault_threshold")
    private long faultThreshold;
    @JsonProperty(value="fault_actions")
    private long faultActions;

    public static DataCheckDesc valueOf(long checkOptions, long faultThreshold, long faultActions) {
        DataCheckDesc instance = new DataCheckDesc();
        instance.checkOptions = checkOptions;
        instance.faultThreshold = faultThreshold;
        instance.faultActions = faultActions;
        return instance;
    }

    public boolean checkDuplicatePK() {
        return CheckOptions.PK_DUPLICATE.match(this.checkOptions);
    }

    public boolean checkDataSkew() {
        return CheckOptions.DATA_SKEW.match(this.checkOptions);
    }

    public boolean checkNullOrBlank() {
        return CheckOptions.NULL_OR_BLANK_VALUE.match(this.checkOptions);
    }

    public boolean checkForceAnalysisLookup() {
        return CheckOptions.FORCE_ANALYSIS_LOOKUP.match(this.checkOptions);
    }

    public boolean isContinue(int count) {
        return (long)count > this.faultThreshold && ActionOptions.CONTINUE.match(this.faultActions);
    }

    public boolean isFailed(int count) {
        return (long)count > this.faultThreshold && ActionOptions.FAILED.match(this.faultActions);
    }

    @Generated
    public long getCheckOptions() {
        return this.checkOptions;
    }

    @Generated
    public long getFaultThreshold() {
        return this.faultThreshold;
    }

    @Generated
    public long getFaultActions() {
        return this.faultActions;
    }

    static enum ActionOptions {
        FAILED(1),
        CONTINUE(2);

        private int value;

        private ActionOptions(int value) {
            this.value = value;
        }

        boolean match(long actionOptions) {
            return (actionOptions & (long)this.value) != 0L;
        }
    }

    static enum CheckOptions {
        PK_DUPLICATE(1),
        DATA_SKEW(2),
        NULL_OR_BLANK_VALUE(4),
        FORCE_ANALYSIS_LOOKUP(8);

        private int value;

        private CheckOptions(int value) {
            this.value = value;
        }

        boolean match(long checkOptions) {
            return (checkOptions & (long)this.value) != 0L;
        }
    }
}

