/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.jar;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.jar.JarInfo;
import org.apache.kylin.metadata.jar.JarTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarInfoManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JarInfoManager.class);
    private KylinConfig kylinConfig;
    private CachedCrudAssist<JarInfo> crud;
    private final String project;

    public static JarInfoManager getInstance(KylinConfig kylinConfig, String project) {
        return (JarInfoManager)kylinConfig.getManager(project, JarInfoManager.class);
    }

    static JarInfoManager newInstance(KylinConfig kylinConfig, String project) {
        return new JarInfoManager(kylinConfig, project);
    }

    private ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.kylinConfig);
    }

    private JarInfoManager(KylinConfig kylinConfig, String project) {
        this.kylinConfig = kylinConfig;
        this.project = project;
        this.crud = new CachedCrudAssist<JarInfo>(this.getStore(), MetadataType.JAR_INFO, project, JarInfo.class){

            @Override
            protected JarInfo initEntityAfterReload(JarInfo entity, String resourceName) {
                return entity;
            }
        };
        this.crud.reloadAll();
    }

    public JarInfo getJarInfo(JarTypeEnum jarTypeEnum, String jarName) {
        if (StringUtils.isEmpty((CharSequence)jarName)) {
            return null;
        }
        return this.crud.get(JarInfo.concatResourceName(this.project, jarTypeEnum, jarName));
    }

    private JarInfo copyForWrite(JarInfo jarInfo) {
        return this.crud.copyForWrite(jarInfo);
    }

    public JarInfo createJarInfo(JarInfo jarInfo) {
        if (Objects.isNull(jarInfo) || StringUtils.isEmpty((CharSequence)jarInfo.resourceName())) {
            throw new IllegalArgumentException("jar info is null or resourceName is null");
        }
        JarInfo copy = this.copyForWrite(jarInfo);
        if (this.crud.contains(copy.resourceName())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUSTOM_PARSER_ALREADY_EXISTS_JAR, new Object[]{copy.getJarName()});
        }
        copy.updateRandomUuid();
        return this.crud.save(copy);
    }

    public JarInfo updateJarInfo(JarTypeEnum jarTypeEnum, String jarName, JarInfoUpdater updater) {
        JarInfo cached = this.getJarInfo(jarTypeEnum, jarName);
        if (cached == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUSTOM_PARSER_NOT_EXISTS_JAR, new Object[]{jarName});
        }
        JarInfo copy = this.copyForWrite(cached);
        updater.modify(copy);
        return this.crud.save(copy);
    }

    public JarInfo removeJarInfo(JarTypeEnum jarTypeEnum, String jarName) {
        JarInfo jarInfo = this.getJarInfo(jarTypeEnum, jarName);
        if (Objects.isNull(jarInfo)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUSTOM_PARSER_NOT_EXISTS_JAR, new Object[]{jarName});
        }
        this.crud.delete(jarInfo);
        return jarInfo;
    }

    public List<JarInfo> listJarInfo() {
        return new ArrayList<JarInfo>(this.crud.listAll());
    }

    public List<JarInfo> listJarInfoByType(JarTypeEnum jarTypeEnum) {
        return this.listJarInfo().stream().filter(jarInfo -> jarTypeEnum == jarInfo.getJarType()).collect(Collectors.toList());
    }

    public static interface JarInfoUpdater {
        public void modify(JarInfo var1);
    }
}

