/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.favorite;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.annotation.Clarification;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Lists;

@Clarification(priority=Clarification.Priority.MAJOR, msg="Enterprise")
public class FavoriteRule {
    public static final String FREQUENCY_RULE_NAME = "frequency";
    public static final String COUNT_RULE_NAME = "count";
    public static final String DURATION_RULE_NAME = "duration";
    public static final String SUBMITTER_RULE_NAME = "submitter";
    public static final String SUBMITTER_GROUP_RULE_NAME = "submitter_group";
    public static final String REC_SELECT_RULE_NAME = "recommendations";
    public static final String EXCLUDED_TABLES_RULE = "excluded_tables";
    public static final String MIN_HIT_COUNT = "min_hit_count";
    public static final String EFFECTIVE_DAYS = "effective_days";
    public static final String UPDATE_FREQUENCY = "update_frequency";
    public static final String FREQUENCY_TIME_WINDOW = "frequency_time_window";
    public static final String LOW_FREQUENCY_THRESHOLD = "low_frequency_threshold";
    public static final int EFFECTIVE_DAYS_MIN = 1;
    public static final int EFFECTIVE_DAYS_MAX = 30;
    public static final String INDEX_PLANNER_ENABLE = "index_planner_enable";
    public static final String INDEX_PLANNER_MAX_INDEX_COUNT = "index_planner_max_index_count";
    public static final String INDEX_PLANNER_MAX_CHANGE_COUNT = "index_planner_max_change_count";
    public static final String INDEX_PLANNER_LEVEL = "index_planner_level";
    public static final String AUTO_INDEX_PLAN_OPTION = "auto_index_plan_option";
    public static final String AUTO_INDEX_PLAN_AUTO_CHANGE_INDEX_ENABLE = "auto_index_plan_auto_change_index_enable";
    public static final String AUTO_INDEX_PLAN_AUTO_COMPLETE_MODE = "auto_index_plan_auto_complete_mode";
    public static final String AUTO_INDEX_PLAN_ABSOLUTE_BEGIN_DATE = "auto_index_plan_absolute_begin_date";
    public static final String AUTO_INDEX_PLAN_RELATIVE_TIME_UNIT = "auto_index_plan_relative_time_unit";
    public static final String AUTO_INDEX_PLAN_RELATIVE_TIME_INTERVAL = "auto_index_plan_relative_time_interval";
    public static final String AUTO_INDEX_PLAN_SEGMENT_JOB_ENABLE = "auto_index_plan_segment_job_enable";
    public static final List<String> FAVORITE_RULE_NAMES = ImmutableList.of((Object)"count", (Object)"frequency", (Object)"duration", (Object)"submitter", (Object)"submitter_group", (Object)"recommendations", (Object)"excluded_tables", (Object)"min_hit_count", (Object)"effective_days", (Object)"update_frequency", (Object)"frequency_time_window", (Object)"low_frequency_threshold", (Object[])new String[0]);
    public static final List<String> AUTO_INDEX_PLAN_RULE_NAMES = ImmutableList.of((Object)"auto_index_plan_option", (Object)"index_planner_enable", (Object)"index_planner_max_index_count", (Object)"index_planner_max_change_count", (Object)"index_planner_level", (Object)"auto_index_plan_auto_change_index_enable", (Object)"auto_index_plan_auto_complete_mode", (Object)"auto_index_plan_absolute_begin_date", (Object)"auto_index_plan_relative_time_unit", (Object)"auto_index_plan_relative_time_interval", (Object)"auto_index_plan_segment_job_enable");
    public static final List<String> INDEX_PLANNER_RULE_NAMES = ImmutableList.of((Object)"auto_index_plan_option", (Object)"index_planner_enable", (Object)"index_planner_max_index_count", (Object)"index_planner_max_change_count", (Object)"index_planner_level");
    public static final List<String> AUTO_COMPLETE_MODES = Arrays.stream(AutoCompleteModeType.values()).map(Enum::name).collect(Collectors.toList());
    public static final List<String> DATE_UNIT_CANDIDATES = Arrays.stream(DateUnitType.values()).map(Enum::name).collect(Collectors.toList());
    private int id;
    private String project;
    private String model;
    private List<AbstractCondition> conds = Lists.newArrayList();
    private String name;
    private boolean enabled;
    private long updateTime;
    private long createTime;
    private long mvcc;

    public FavoriteRule(List<AbstractCondition> conds, String name, boolean isEnabled) {
        this.conds = conds;
        this.name = name;
        this.enabled = isEnabled;
    }

    public static List<FavoriteRule> getRecommendDefaultRule() {
        return FAVORITE_RULE_NAMES.stream().map(ruleName -> FavoriteRule.getDefaultRuleIfNull(null, ruleName)).collect(Collectors.toList());
    }

    public static List<FavoriteRule> getAutoIndexPlanDefaultRule() {
        return AUTO_INDEX_PLAN_RULE_NAMES.stream().map(ruleName -> FavoriteRule.getDefaultRuleIfNull(null, ruleName)).collect(Collectors.toList());
    }

    public static FavoriteRule getDefaultRuleIfNull(FavoriteRule rule, String name) {
        if (AUTO_INDEX_PLAN_RULE_NAMES.contains(name)) {
            return rule == null ? new FavoriteRule(Lists.newArrayList((Object[])new AbstractCondition[]{FavoriteRule.getDefaultAutoIndexPlanCondition(name)}), name, true) : rule;
        }
        switch (name) {
            case "count": 
            case "submitter_group": 
            case "submitter": 
            case "recommendations": 
            case "min_hit_count": 
            case "update_frequency": 
            case "effective_days": 
            case "duration": 
            case "frequency_time_window": 
            case "low_frequency_threshold": {
                return rule == null ? new FavoriteRule(Lists.newArrayList((Object[])new AbstractCondition[]{FavoriteRule.getDefaultCondition(name)}), name, true) : rule;
            }
            case "frequency": 
            case "excluded_tables": {
                return rule == null ? new FavoriteRule(Lists.newArrayList((Object[])new AbstractCondition[]{FavoriteRule.getDefaultCondition(name)}), name, false) : rule;
            }
        }
        return rule;
    }

    public static Condition getDefaultCondition(String ruleName) {
        switch (ruleName) {
            case "count": {
                return new Condition(null, "10");
            }
            case "frequency": {
                return new Condition(null, "0.1");
            }
            case "submitter": {
                return new Condition(null, "ADMIN");
            }
            case "submitter_group": {
                return new Condition(null, "ROLE_ADMIN");
            }
            case "duration": {
                return new Condition("5", "3600");
            }
            case "recommendations": {
                return new Condition(null, "20");
            }
            case "excluded_tables": {
                return new Condition(null, "");
            }
            case "min_hit_count": {
                return new Condition(null, "30");
            }
            case "update_frequency": 
            case "effective_days": {
                return new Condition(null, "2");
            }
            case "low_frequency_threshold": {
                return new Condition(null, "0");
            }
            case "frequency_time_window": {
                return new Condition(null, DateUnitType.MONTH.name());
            }
        }
        return null;
    }

    public static Condition getDefaultAutoIndexPlanCondition(String ruleName) {
        switch (ruleName) {
            case "index_planner_enable": {
                return new Condition(null, "false");
            }
            case "index_planner_max_index_count": {
                return new Condition(null, "100");
            }
            case "index_planner_max_change_count": {
                return new Condition(null, "10");
            }
            case "index_planner_level": {
                return new Condition(null, IndexPlannerLevelType.BALANCED.name());
            }
            case "auto_index_plan_segment_job_enable": 
            case "auto_index_plan_auto_change_index_enable": {
                return new Condition(null, "true");
            }
            case "auto_index_plan_auto_complete_mode": {
                return new Condition(null, "RELATIVE");
            }
            case "auto_index_plan_relative_time_unit": {
                return new Condition(null, DateUnitType.MONTH.name());
            }
            case "auto_index_plan_relative_time_interval": {
                return new Condition(null, "12");
            }
            case "auto_index_plan_absolute_begin_date": {
                return new Condition(null, null);
            }
        }
        return null;
    }

    public static int getTimeWindowLength(String timeUnit) {
        switch (timeUnit) {
            case "DAY": {
                return 1;
            }
            case "WEEK": {
                return 7;
            }
            case "MONTH": {
                return 30;
            }
            case "QUARTER": {
                return 90;
            }
        }
        throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, "Illegal parameter 'frequency_time_window'!");
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public List<AbstractCondition> getConds() {
        return this.conds;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public long getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public long getMvcc() {
        return this.mvcc;
    }

    @Generated
    public void setId(int id) {
        this.id = id;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setConds(List<AbstractCondition> conds) {
        this.conds = conds;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setMvcc(long mvcc) {
        this.mvcc = mvcc;
    }

    @Generated
    public FavoriteRule() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FavoriteRule)) {
            return false;
        }
        FavoriteRule other = (FavoriteRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<AbstractCondition> this$conds = this.getConds();
        List<AbstractCondition> other$conds = other.getConds();
        if (this$conds == null ? other$conds != null : !((Object)this$conds).equals(other$conds)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getUpdateTime() != other.getUpdateTime()) {
            return false;
        }
        if (this.getCreateTime() != other.getCreateTime()) {
            return false;
        }
        return this.getMvcc() == other.getMvcc();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FavoriteRule;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<AbstractCondition> $conds = this.getConds();
        result = result * 59 + ($conds == null ? 43 : ((Object)$conds).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        long $updateTime = this.getUpdateTime();
        result = result * 59 + (int)($updateTime >>> 32 ^ $updateTime);
        long $createTime = this.getCreateTime();
        result = result * 59 + (int)($createTime >>> 32 ^ $createTime);
        long $mvcc = this.getMvcc();
        result = result * 59 + (int)($mvcc >>> 32 ^ $mvcc);
        return result;
    }

    public static class SQLCondition
    extends AbstractCondition {
        private String id;
        @JsonProperty(value="sql_pattern")
        private String sqlPattern;
        @JsonProperty(value="create_time")
        private long createTime;

        public SQLCondition() {
            this.id = RandomUtil.randomUUIDStr();
        }

        public SQLCondition(String sqlPattern) {
            this();
            this.sqlPattern = sqlPattern;
            this.createTime = System.currentTimeMillis();
        }

        @VisibleForTesting
        public SQLCondition(String id, String sqlPattern) {
            this.id = id;
            this.sqlPattern = sqlPattern;
            this.createTime = System.currentTimeMillis();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SQLCondition that = (SQLCondition)obj;
            return this.sqlPattern.equalsIgnoreCase(that.getSqlPattern());
        }

        public int hashCode() {
            return this.sqlPattern.hashCode();
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getSqlPattern() {
            return this.sqlPattern;
        }

        @Generated
        public long getCreateTime() {
            return this.createTime;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setSqlPattern(String sqlPattern) {
            this.sqlPattern = sqlPattern;
        }

        @Generated
        public void setCreateTime(long createTime) {
            this.createTime = createTime;
        }
    }

    public static class Condition
    extends AbstractCondition {
        private String leftThreshold;
        private String rightThreshold;

        public Condition(String leftThreshold, String rightThreshold) {
            this.leftThreshold = leftThreshold;
            this.rightThreshold = rightThreshold;
        }

        @Generated
        public String getLeftThreshold() {
            return this.leftThreshold;
        }

        @Generated
        public String getRightThreshold() {
            return this.rightThreshold;
        }

        @Generated
        public void setLeftThreshold(String leftThreshold) {
            this.leftThreshold = leftThreshold;
        }

        @Generated
        public void setRightThreshold(String rightThreshold) {
            this.rightThreshold = rightThreshold;
        }

        @Generated
        public Condition() {
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Condition.class), @JsonSubTypes.Type(value=SQLCondition.class)})
    public static abstract class AbstractCondition
    implements Serializable {
        @Generated
        public AbstractCondition() {
        }
    }

    public static enum IndexPlannerLevelType {
        HIGH_PERFORMANCE,
        BALANCED,
        LOW_COST;

    }

    public static enum AutoCompleteModeType {
        ABSOLUTE,
        RELATIVE;

    }

    public static enum DateUnitType {
        DAY,
        WEEK,
        MONTH,
        QUARTER,
        YEAR;

    }
}

