/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.storage;

import java.io.IOException;
import lombok.Generated;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.metadata.cube.storage.StorageInfoCollector;
import org.apache.kylin.metadata.cube.storage.StorageInfoEnum;
import org.apache.kylin.metadata.cube.storage.StorageVolumeInfo;
import org.apache.kylin.metrics.HdfsCapacityMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TotalStorageCollector
implements StorageInfoCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TotalStorageCollector.class);
    private HdfsCapacityMetrics hdfsCapacityMetrics = new HdfsCapacityMetrics(KylinConfig.getInstanceFromEnv());

    @Override
    public void doCollect(KylinConfig config, String project, StorageVolumeInfo storageVolumeInfo) throws IOException {
        long totalStorageSize = this.hdfsCapacityMetrics.getHdfsCapacityByProject(project);
        if (totalStorageSize != -1L) {
            log.debug("Reuse workingDirCapacity by project {}, storageSize: {}", (Object)project, (Object)totalStorageSize);
            storageVolumeInfo.setTotalStorageSize(totalStorageSize);
            return;
        }
        String strPath = config.getWorkingDirectoryWithConfiguredFs(project);
        Path path = new Path(strPath);
        FileSystem fs = path.getFileSystem(HadoopUtil.getCurrentConfiguration());
        totalStorageSize = 0L;
        if (fs.exists(path)) {
            totalStorageSize = HadoopUtil.getContentSummary((FileSystem)fs, (Path)path).getLength();
        }
        storageVolumeInfo.setTotalStorageSize(totalStorageSize);
    }

    @Override
    public StorageInfoEnum getType() {
        return StorageInfoEnum.TOTAL_STORAGE;
    }
}

