/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.cube.cuboid.NAggregationGroup;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;
import org.apache.kylin.metadata.cube.planner.algorithm.AbstractRecommendAlgorithm;
import org.apache.kylin.metadata.cube.planner.algorithm.CuboidStats;
import org.apache.kylin.metadata.cube.planner.algorithm.PBPUSCalculator;
import org.apache.kylin.metadata.cube.planner.algorithm.genetic.GeneticAlgorithm;
import org.apache.kylin.metadata.cube.planner.algorithm.greedy.GreedyAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CostBasePlannerUtils {
    private static final Logger logger = LoggerFactory.getLogger(CostBasePlannerUtils.class);

    public static Map<BigInteger, Long> getRecommendCuboidList(RuleBasedIndex ruleBasedIndex, KylinConfig kylinConf, String modelName, Map<BigInteger, Long> cuboidRowCountMap, Map<BigInteger, Double> cuboidSizeMap) {
        BigInteger baseCuboid = CostBasePlannerUtils.generateBaseCuboId(ruleBasedIndex);
        Set<BigInteger> mandatoryCuboids = CostBasePlannerUtils.generateMandatoryCuboIds(ruleBasedIndex);
        logger.info("Build cuboid stats model name {}, baseCuboid {}, mandatory cuboid {}, statistic cuboid {}", new Object[]{modelName, baseCuboid, mandatoryCuboids, cuboidRowCountMap.keySet()});
        CuboidStats cuboidStats = new CuboidStats.Builder(modelName, baseCuboid, baseCuboid, cuboidRowCountMap, cuboidSizeMap).setMandatoryCuboids(mandatoryCuboids).setBPUSMinBenefitRatio(kylinConf.getCostBasedPlannerBPUSMinBenefitRatio()).build();
        Map<BigInteger, Long> result = CostBasePlannerUtils.getRecommendCuboidList(cuboidStats, kylinConf, !mandatoryCuboids.isEmpty());
        if (result == null || result.isEmpty()) {
            result = new HashMap<BigInteger, Long>();
            Set<LayoutEntity> allLayouts = ruleBasedIndex.genCuboidLayouts();
            for (LayoutEntity layoutEntity : allLayouts) {
                BigInteger cuboid = CostBasePlannerUtils.convertDimensionsToCuboId(layoutEntity.getDimsIds(), ruleBasedIndex.countOfIncludeDimension(), ruleBasedIndex.getColumnIdToRowKeyId());
                result.put(cuboid, 0L);
            }
            logger.info("Not recommend any cuboid with the cost based method, and use the rule based cuboid {}", result.keySet());
        }
        return result;
    }

    private static BigInteger generateBaseCuboId(RuleBasedIndex ruleBasedIndex) {
        int dimensionCount = ruleBasedIndex.countOfIncludeDimension();
        ArrayList<Integer> dimensionIds = new ArrayList<Integer>(ruleBasedIndex.getDimensions());
        BigInteger cuboid = CostBasePlannerUtils.convertDimensionsToCuboId(dimensionIds, dimensionCount, ruleBasedIndex.getColumnIdToRowKeyId());
        return cuboid;
    }

    private static Set<BigInteger> generateMandatoryCuboIds(RuleBasedIndex ruleBasedIndex) {
        HashSet<BigInteger> result = new HashSet<BigInteger>();
        if (ruleBasedIndex != null) {
            int dimensionCount = ruleBasedIndex.countOfIncludeDimension();
            for (NAggregationGroup aggregationGroup : ruleBasedIndex.getAggregationGroups()) {
                Integer[] mandatoryDimensionIds = aggregationGroup.getSelectRule().getMandatoryDims();
                if (mandatoryDimensionIds == null || mandatoryDimensionIds.length == 0) continue;
                BigInteger cuboid = CostBasePlannerUtils.convertDimensionsToCuboId(mandatoryDimensionIds, dimensionCount, ruleBasedIndex.getColumnIdToRowKeyId());
                result.add(cuboid);
            }
        }
        return result;
    }

    private static Map<BigInteger, Long> getRecommendCuboidList(CuboidStats cuboidStats, KylinConfig kylinConf, boolean ifForceRecommend) {
        long threshold2;
        long threshold1 = 1L << kylinConf.getCostBasedPlannerGreedyAlgorithmAutoThreshold() - 1;
        if (threshold1 >= (threshold2 = 1L << kylinConf.getCostBasedPlannerGeneticAlgorithmAutoThreshold() - 1)) {
            logger.error("Invalid Cube Planner Algorithm configuration");
            return null;
        }
        int allCuboidCount = cuboidStats.getAllCuboidsForMandatory().size() + cuboidStats.getAllCuboidsForSelection().size();
        if (!ifForceRecommend && (long)allCuboidCount < threshold1) {
            logger.info("Not recommend cuboid, the all cuboid count is {}, the threshold1 is {}, force recommend {}", new Object[]{allCuboidCount, threshold1, ifForceRecommend});
            return null;
        }
        PBPUSCalculator benefitPolicy = new PBPUSCalculator(cuboidStats);
        AbstractRecommendAlgorithm algorithm = null;
        algorithm = (long)allCuboidCount <= threshold2 ? new GreedyAlgorithm(-1L, benefitPolicy, cuboidStats) : new GeneticAlgorithm(-1L, benefitPolicy, cuboidStats);
        long startTime = System.currentTimeMillis();
        logger.info("Cube Planner Algorithm started at {}", (Object)startTime);
        List<BigInteger> recommendCuboidList = algorithm.recommend(kylinConf.getCostBasedPlannerExpansionRateThreshold());
        logger.info("Cube Planner Algorithm ended at {}, cost time {}", (Object)System.currentTimeMillis(), (Object)(System.currentTimeMillis() - startTime));
        if (recommendCuboidList.size() < allCuboidCount) {
            logger.info("Cube Planner Algorithm chooses {} most effective cuboids to build among of all {} cuboids.", (Object)recommendCuboidList.size(), (Object)allCuboidCount);
        }
        LinkedHashMap recommendCuboidsWithStats = Maps.newLinkedHashMap();
        for (BigInteger cuboid : recommendCuboidList) {
            if (cuboid.equals(BigInteger.ZERO)) {
                CostBasePlannerUtils.handleCuboidZeroRecommend(cuboidStats, recommendCuboidsWithStats);
                continue;
            }
            recommendCuboidsWithStats.put(cuboid, cuboidStats.getCuboidCount(cuboid));
        }
        return recommendCuboidsWithStats;
    }

    private static void handleCuboidZeroRecommend(CuboidStats cuboidStats, Map<BigInteger, Long> recommendCuboidsWithStats) {
        Map<BigInteger, Long> statistics = cuboidStats.getStatistics();
        BigInteger cheapestCuboid = null;
        Long cheapestCuboidCount = Long.MAX_VALUE;
        for (Map.Entry<BigInteger, Long> cuboidStatsEntry : statistics.entrySet()) {
            if (cuboidStatsEntry.getValue() >= cheapestCuboidCount) continue;
            cheapestCuboid = cuboidStatsEntry.getKey();
            cheapestCuboidCount = cuboidStatsEntry.getValue();
        }
        if (cheapestCuboid != null) {
            logger.info("recommend cuboid:{} instead of cuboid zero", cheapestCuboid);
            recommendCuboidsWithStats.put(cheapestCuboid, cheapestCuboidCount);
        }
    }

    private static BigInteger convertDimensionsToCuboId(Integer[] dimensionIds, int dimensionCount, Map<Integer, Integer> columnIdToRowkeyId) {
        Preconditions.checkNotNull((Object)dimensionIds);
        Preconditions.checkArgument((dimensionIds.length != 0 ? 1 : 0) != 0, (Object)"The length of dimensionIds must be greater than 0");
        BigInteger cuboid = BigInteger.ZERO;
        for (Integer dimensionId : dimensionIds) {
            if (!columnIdToRowkeyId.containsKey(dimensionId)) {
                throw new RuntimeException("Can't find the rowkey id for the dimension id");
            }
            int rowkeyId = columnIdToRowkeyId.get(dimensionId);
            if (rowkeyId >= dimensionCount) {
                throw new RuntimeException("The rowkey id must less than the count of dimension");
            }
            cuboid = cuboid.setBit(dimensionCount - 1 - rowkeyId);
        }
        return cuboid;
    }

    public static BigInteger convertDimensionsToCuboId(List<Integer> dimensionIds, int dimensionCount, Map<Integer, Integer> columnIdToRowkeyId) {
        return CostBasePlannerUtils.convertDimensionsToCuboId(dimensionIds.toArray(new Integer[0]), dimensionCount, columnIdToRowkeyId);
    }
}

