/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.optimization;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.common.annotation.Clarification;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.optimization.GarbageLayoutType;

@Clarification(priority=Clarification.Priority.MAJOR, msg="Enterprise")
public abstract class AbstractOptStrategy {
    private GarbageLayoutType type;

    protected abstract Set<Long> doCollect(List<LayoutEntity> var1, NDataflow var2, boolean var3);

    public final Set<Long> collectGarbageLayouts(List<LayoutEntity> inputLayouts, NDataflow dataflow, boolean needLog) {
        List<LayoutEntity> toHandleLayouts = this.beforeCollect(inputLayouts);
        Set<Long> garbageSet = this.doCollect(toHandleLayouts, dataflow, needLog);
        this.afterCollect(inputLayouts, garbageSet);
        return garbageSet;
    }

    private List<LayoutEntity> beforeCollect(List<LayoutEntity> inputLayouts) {
        ArrayList layoutsToHandle = Lists.newArrayList(inputLayouts);
        this.skipOptimizeIndex(layoutsToHandle);
        return layoutsToHandle;
    }

    protected abstract void skipOptimizeIndex(List<LayoutEntity> var1);

    private void afterCollect(List<LayoutEntity> inputLayouts, Set<Long> garbages) {
        inputLayouts.removeIf(layout -> garbages.contains(layout.getId()));
    }

    @Generated
    public GarbageLayoutType getType() {
        return this.type;
    }

    @Generated
    protected void setType(GarbageLayoutType type) {
        this.type = type;
    }
}

