/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegDetailsManager;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class NDataSegDetails
extends RootPersistentEntity
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(NDataSegDetailsManager.class);
    public static final String DATAFLOW_DETAILS_RESOURCE_ROOT = "/dataflow_details";
    @JsonProperty(value="dataflow")
    private String dataflowId;
    @JsonManagedReference
    @JsonProperty(value="layout_instances")
    private List<NDataLayout> layouts = Lists.newArrayList();
    @JsonIgnore
    private KylinConfigExt config;

    public static NDataSegDetails newSegDetails(NDataflow df, String segId) {
        NDataSegDetails entity = new NDataSegDetails();
        entity.setConfig(df.getConfig());
        entity.setUuid(segId);
        entity.setDataflowId(df.getUuid());
        entity.setProject(df.getProject());
        ArrayList<NDataLayout> cuboids = new ArrayList<NDataLayout>();
        entity.setLayouts(cuboids);
        return entity;
    }

    public KylinConfigExt getConfig() {
        return this.config;
    }

    void setConfig(KylinConfigExt config) {
        this.config = config;
    }

    public NDataflow getDataflow() {
        return NDataflowManager.getInstance((KylinConfig)this.getConfig(), this.project).getDataflow(this.dataflowId);
    }

    public NDataSegment getDataSegment() {
        return this.getDataflow().getSegment(this.uuid);
    }

    public String getDataflowId() {
        return this.dataflowId;
    }

    public void setDataflowId(String dfName) {
        this.checkIsNotCachedAndShared();
        this.dataflowId = dfName;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public long getTotalRowCount() {
        long count = 0L;
        for (NDataLayout cuboid : this.getEffectiveLayouts()) {
            count += cuboid.getRows();
        }
        return count;
    }

    @Deprecated
    public List<NDataLayout> getLayouts() {
        return this.getAllLayouts();
    }

    public List<NDataLayout> getEffectiveLayouts() {
        ImmutableList effectiveLayouts = this.getLayouts0(false);
        return this.isCachedAndShared() ? ImmutableList.copyOf(effectiveLayouts) : effectiveLayouts;
    }

    public List<NDataLayout> getAllLayouts() {
        ImmutableList allLayouts = this.getLayouts0(true);
        return this.isCachedAndShared() ? ImmutableList.copyOf(allLayouts) : allLayouts;
    }

    private List<NDataLayout> getLayouts0(boolean includingNonEffectiveLayouts) {
        if (includingNonEffectiveLayouts) {
            return this.layouts;
        }
        return this.layouts.stream().filter(NDataLayout::filterEffectiveLayout).collect(Collectors.toList());
    }

    public NDataLayout getLayoutById(long layoutId) {
        for (NDataLayout cuboid : this.getAllLayouts()) {
            if (cuboid.getLayoutId() != layoutId) continue;
            return cuboid;
        }
        return null;
    }

    public void setLayouts(List<NDataLayout> layouts) {
        this.checkIsNotCachedAndShared();
        this.layouts = layouts;
    }

    void addLayout(NDataLayout cuboid) {
        this.checkIsNotCachedAndShared();
        if (this.layouts.contains(cuboid)) {
            this.layouts.remove(cuboid);
        }
        this.layouts.add(cuboid);
    }

    void removeLayout(NDataLayout cuboid) {
        this.checkIsNotCachedAndShared();
        this.layouts.remove(cuboid);
    }

    boolean checkLayoutsBeforeMerge(NDataSegDetails another) {
        if (another == this) {
            return false;
        }
        List<NDataLayout> currentSortedLayouts = NDataSegDetails.getSortedLayouts(this.getAllLayouts());
        List<NDataLayout> anotherSortedLayouts = NDataSegDetails.getSortedLayouts(another.getAllLayouts());
        int size = currentSortedLayouts.size();
        if (size != anotherSortedLayouts.size()) {
            return false;
        }
        if (size == 0) {
            return true;
        }
        for (int i = 0; i < size; ++i) {
            if (currentSortedLayouts.get(i).getLayoutId() == anotherSortedLayouts.get(i).getLayoutId()) continue;
            return false;
        }
        return true;
    }

    private static List<NDataLayout> getSortedLayouts(List<NDataLayout> layouts) {
        layouts.sort((o1, o2) -> (int)(o1.getLayoutId() - o2.getLayoutId()));
        return layouts;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dataflowId == null ? 0 : this.dataflowId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NDataSegDetails other = (NDataSegDetails)obj;
        if (!this.uuid.equals(other.uuid)) {
            return false;
        }
        if (this.dataflowId == null) {
            return other.dataflowId == null;
        }
        return this.dataflowId.equals(other.dataflowId);
    }

    public String toString() {
        return "NDataSegDetails [" + this.dataflowId + "." + this.uuid + "]";
    }

    public MetadataType resourceType() {
        return MetadataType.LAYOUT;
    }
}

