/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.cuboid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.basic.BasicMeasureType;
import org.apache.kylin.metadata.cube.cuboid.ChooserContext;
import org.apache.kylin.metadata.cube.cuboid.IndexMatcher;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.model.AntiFlatChecker;
import org.apache.kylin.metadata.model.ColExcludedChecker;
import org.apache.kylin.metadata.model.DeriveInfo;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggIndexMatcher
extends IndexMatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AggIndexMatcher.class);
    private final Map<FunctionDesc, List<Integer>> functionCols = Maps.newHashMap();

    public AggIndexMatcher(SQLDigest sqlDigest, ChooserContext chooserContext, NDataflow dataflow, ColExcludedChecker exColChecker, AntiFlatChecker antiFlatChecker) {
        super(sqlDigest, chooserContext, dataflow, exColChecker, antiFlatChecker);
        this.valid = this.fastValidCheckBeforeMatch();
    }

    @Override
    protected boolean fastValidCheckBeforeMatch() {
        this.sqlColumns = Stream.concat(this.sqlDigest.getFilterColumns().stream(), this.sqlDigest.getGroupByColumns().stream()).map(this.tblColMap::get).collect(Collectors.toSet());
        if (this.sqlColumns.contains(null)) {
            return false;
        }
        for (FunctionDesc agg : this.sqlDigest.getAggregations()) {
            List cols = agg.getSourceColRefs().stream().map(this.tblColMap::get).collect(Collectors.toList());
            for (Integer col : cols) {
                if (col != null) continue;
                return false;
            }
            this.functionCols.put(agg, cols);
        }
        return true;
    }

    @Override
    public IndexMatcher.MatchResult match(LayoutEntity layout) {
        boolean matched;
        if (this.canSkipIndexMatch(layout.getIndex()) || !this.isValid()) {
            return new IndexMatcher.MatchResult();
        }
        log.trace("Matching agg index");
        ArrayList unmatchedMetrics = Lists.newArrayList(this.sqlDigest.getAggregations());
        Set<Integer> unmatchedCols = this.initUnmatchedColumnIds(layout);
        HashMap needDerive = Maps.newHashMap();
        this.goThruDerivedDims(layout.getIndex(), needDerive, unmatchedCols);
        this.unmatchedAggregations(unmatchedMetrics, layout);
        if (NProjectManager.getProjectConfig(this.project).isReplaceColCountWithCountStar()) {
            this.unmatchedCountColumnIfExistCountStar(unmatchedMetrics);
        }
        this.removeUnmatchedGroupingAgg(unmatchedMetrics);
        ArrayList influences = Lists.newArrayList();
        if (!unmatchedMetrics.isEmpty() || !unmatchedCols.isEmpty()) {
            this.applyAdvanceMeasureStrategy(layout, unmatchedCols, unmatchedMetrics, influences);
            this.applyDimAsMeasureStrategy(layout, unmatchedMetrics, needDerive, influences);
        }
        boolean bl = matched = unmatchedCols.isEmpty() && unmatchedMetrics.isEmpty();
        if (!matched) {
            unmatchedCols.removeAll(this.filterExcludedDims(layout));
            log.debug("After rolling back to AggIndex to match, the unmatched columns are: ({}), the unmatched measures are: ({})", unmatchedCols, (Object)unmatchedMetrics);
            boolean bl2 = matched = unmatchedMetrics.isEmpty() && unmatchedCols.isEmpty();
        }
        if (!matched && log.isDebugEnabled()) {
            log.debug("Agg index {} with unmatched columns {}, unmatched metrics {}", new Object[]{layout, unmatchedCols, unmatchedMetrics});
        }
        return new IndexMatcher.MatchResult(matched, needDerive, null, influences);
    }

    @Override
    protected boolean canSkipIndexMatch(IndexEntity indexEntity) {
        return indexEntity.isTableIndex() || this.sqlDigest.isRawQuery;
    }

    private void removeUnmatchedGroupingAgg(Collection<FunctionDesc> unmatchedAggregations) {
        if (CollectionUtils.isEmpty(unmatchedAggregations)) {
            return;
        }
        unmatchedAggregations.removeIf(functionDesc -> "GROUPING".equalsIgnoreCase(functionDesc.getExpression()));
    }

    private void unmatchedAggregations(Collection<FunctionDesc> aggregations, LayoutEntity cuboidLayout) {
        ArrayList functionDescs = new ArrayList();
        if (this.isBatchFusionModel) {
            functionDescs.addAll(cuboidLayout.getStreamingMeasures().values());
        }
        functionDescs.addAll(cuboidLayout.getOrderedMeasures().values());
        for (MeasureDesc measureDesc : functionDescs) {
            aggregations.removeIf(functionDesc -> measureDesc.getFunction().equals(functionDesc));
        }
    }

    private void unmatchedCountColumnIfExistCountStar(Collection<FunctionDesc> aggregations) {
        aggregations.removeIf(FunctionDesc::isCountOnColumn);
    }

    private void applyDimAsMeasureStrategy(LayoutEntity layoutEntity, Collection<FunctionDesc> unmatchedAggs, Map<Integer, DeriveInfo> needDeriveCollector, List<CapabilityResult.CapabilityInfluence> influences) {
        IndexEntity indexEntity = layoutEntity.getIndex();
        Iterator<FunctionDesc> it = unmatchedAggs.iterator();
        HashSet matchedAggs = Sets.newHashSet();
        while (it.hasNext()) {
            FunctionDesc functionDesc = it.next();
            if (matchedAggs.contains(functionDesc)) {
                influences.add(new CapabilityResult.DimensionAsMeasure(functionDesc));
                it.remove();
                continue;
            }
            if (functionDesc.isCountConstant()) {
                it.remove();
                continue;
            }
            if (CollectionUtils.isEmpty(functionDesc.getParameters())) continue;
            HashSet dimensionCols = Sets.newHashSet(indexEntity.getDimensions());
            if (this.isBatchFusionModel) {
                dimensionCols.addAll(layoutEntity.getStreamingColumns().keySet());
            }
            HashSet leftUnmatchedCols = Sets.newHashSet((Iterable)this.functionCols.get(functionDesc));
            dimensionCols.forEach(leftUnmatchedCols::remove);
            if (CollectionUtils.isNotEmpty((Collection)leftUnmatchedCols)) {
                this.goThruDerivedDims(indexEntity, needDeriveCollector, leftUnmatchedCols);
            }
            if (CollectionUtils.isNotEmpty((Collection)leftUnmatchedCols) || !FunctionDesc.DIMENSION_AS_MEASURES.contains((Object)functionDesc.getExpression())) continue;
            influences.add(new CapabilityResult.DimensionAsMeasure(functionDesc));
            matchedAggs.add(functionDesc);
            it.remove();
        }
    }

    private void applyAdvanceMeasureStrategy(LayoutEntity layoutEntity, Collection<Integer> unmatchedDims, Collection<FunctionDesc> unmatchedMetrics, List<CapabilityResult.CapabilityInfluence> influences) {
        IndexEntity indexEntity = layoutEntity.getIndex();
        ArrayList influencingMeasures = Lists.newArrayList();
        HashSet measureSet = Sets.newHashSet(indexEntity.getMeasureSet());
        if (this.isBatchFusionModel) {
            measureSet.addAll(layoutEntity.getStreamingMeasures().values());
        }
        for (MeasureDesc measure : measureSet) {
            MeasureType measureType = measure.getFunction().getMeasureType();
            if (measureType instanceof BasicMeasureType) continue;
            HashSet<TblColRef> dimRefs = new HashSet<TblColRef>(this.chooserContext.convertToRefs(unmatchedDims));
            CapabilityResult.CapabilityInfluence inf = measureType.influenceCapabilityCheck(dimRefs, unmatchedMetrics, this.sqlDigest, measure);
            unmatchedDims.removeIf(dim -> !dimRefs.contains(this.chooserContext.convertToRef((Integer)dim)));
            if (inf == null) continue;
            influences.add(inf);
            influencingMeasures.add(measure.getName() + "@" + measureType.getClass());
        }
        if (!influencingMeasures.isEmpty()) {
            log.info("NDataflow {} CapabilityInfluences: {}", (Object)this.dataflow.getUuid(), (Object)StringUtils.join((Iterable)influencingMeasures, (String)","));
        }
    }
}

