/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.bitmap;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.bitmap.BitmapAggFunc;
import org.apache.kylin.measure.bitmap.BitmapAggregator;
import org.apache.kylin.measure.bitmap.BitmapBuildAggFunc;
import org.apache.kylin.measure.bitmap.BitmapCountAggFunc;
import org.apache.kylin.measure.bitmap.BitmapCounter;
import org.apache.kylin.measure.bitmap.BitmapCounterFactory;
import org.apache.kylin.measure.bitmap.BitmapDistinctCountAggFunc;
import org.apache.kylin.measure.bitmap.BitmapSerializer;
import org.apache.kylin.measure.bitmap.RoaringBitmapCounterFactory;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.SQLDigest;

public class BitmapMeasureType
extends MeasureType<BitmapCounter> {
    public static final String FUNC_COUNT_DISTINCT = "COUNT_DISTINCT";
    public static final String DATATYPE_BITMAP = "bitmap";
    public DataType dataType;
    static final Map<String, Class<?>> UDAF_MAP = ImmutableMap.of((Object)"COUNT_DISTINCT", BitmapDistinctCountAggFunc.class, (Object)"BITMAP_UUID", BitmapAggFunc.class, (Object)"BITMAP_COUNT", BitmapCountAggFunc.class, (Object)"BITMAP_BUILD", BitmapBuildAggFunc.class);

    public BitmapMeasureType(String funcName, DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public void validate(FunctionDesc functionDesc) throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)FUNC_COUNT_DISTINCT.equals(functionDesc.getExpression()), (String)"BitmapMeasureType only support function %s, got %s", (Object)FUNC_COUNT_DISTINCT, (Object)functionDesc.getExpression());
        Preconditions.checkArgument((functionDesc.getParameterCount() == 1 ? 1 : 0) != 0, (String)"BitmapMeasureType only support 1 parameter, got %d", (int)functionDesc.getParameterCount());
        String returnType = functionDesc.getReturnDataType().getName();
        Preconditions.checkArgument((boolean)DATATYPE_BITMAP.equals(returnType), (String)"BitmapMeasureType's return type must be %s, got %s", (Object)DATATYPE_BITMAP, (Object)returnType);
    }

    @Override
    public boolean isMemoryHungry() {
        return true;
    }

    @Override
    public MeasureIngester<BitmapCounter> newIngester() {
        final BitmapCounterFactory factory = RoaringBitmapCounterFactory.INSTANCE;
        return new MeasureIngester<BitmapCounter>(){
            BitmapCounter current;
            {
                this.current = factory.newBitmap();
            }

            @Override
            public BitmapCounter valueOf(String[] values, MeasureDesc measureDesc, Map<TblColRef, Dictionary<String>> dictionaryMap) {
                int id;
                Preconditions.checkArgument((values.length == 1 ? 1 : 0) != 0, (String)"expect 1 value, got %s", (Object)Arrays.toString(values));
                this.current.clear();
                if (values[0] == null) {
                    return this.current;
                }
                if (BitmapMeasureType.this.needDictionaryColumn(measureDesc.getFunction())) {
                    TblColRef literalCol = measureDesc.getFunction().getColRefs().get(0);
                    Dictionary<String> dictionary = dictionaryMap.get(literalCol);
                    id = dictionary.getIdFromValue((Object)values[0]);
                } else {
                    id = Integer.parseInt(values[0]);
                }
                this.current.add(id);
                return this.current;
            }

            @Override
            public BitmapCounter reEncodeDictionary(BitmapCounter value, MeasureDesc measureDesc, Map<TblColRef, Dictionary<String>> oldDicts, Map<TblColRef, Dictionary<String>> newDicts) {
                return value;
            }

            @Override
            public void reset() {
                this.current = factory.newBitmap();
            }
        };
    }

    @Override
    public MeasureAggregator<BitmapCounter> newAggregator() {
        return new BitmapAggregator();
    }

    @Override
    public List<TblColRef> getColumnsNeedDictionary(FunctionDesc functionDesc) {
        if (this.needDictionaryColumn(functionDesc)) {
            return Collections.singletonList(functionDesc.getColRefs().get(0));
        }
        return Collections.emptyList();
    }

    private boolean needDictionaryColumn(FunctionDesc functionDesc) {
        DataType dataType = functionDesc.getColRefs().get(0).getType();
        return !dataType.isIntegerFamily() || dataType.isBigInt();
    }

    @Override
    public boolean needRewrite() {
        return true;
    }

    @Override
    public Map<String, Class<?>> getRewriteCalciteAggrFunctions() {
        return UDAF_MAP;
    }

    @Override
    public CapabilityResult.CapabilityInfluence influenceCapabilityCheck(Collection<TblColRef> unmatchedDimensions, Collection<FunctionDesc> unmatchedAggregations, SQLDigest digest, final MeasureDesc bitmap) {
        if (unmatchedAggregations.size() == 0) {
            return null;
        }
        boolean chosen = false;
        Iterator<FunctionDesc> iterator = unmatchedAggregations.iterator();
        while (iterator.hasNext()) {
            FunctionDesc functionDesc = iterator.next();
            String expression = functionDesc.getExpression();
            if (!expression.equals("INTERSECT_COUNT") && !expression.equals("BITMAP_UUID") && !expression.equals("BITMAP_BUILD")) continue;
            TblColRef countDistinctCol = functionDesc.getParameters().get(0).getColRef();
            boolean equals = bitmap.getFunction().getParameters().get(0).getColRef().equals(countDistinctCol);
            if (!equals) continue;
            chosen = true;
            iterator.remove();
        }
        if (chosen) {
            return new CapabilityResult.CapabilityInfluence(){

                @Override
                public double suggestCostMultiplier() {
                    return 0.9;
                }

                @Override
                public MeasureDesc getInvolvedMeasure() {
                    return bitmap;
                }
            };
        }
        return null;
    }

    public static class Factory
    extends MeasureTypeFactory<BitmapCounter> {
        @Override
        public MeasureType<BitmapCounter> createMeasureType(String funcName, DataType dataType) {
            return new BitmapMeasureType(funcName, dataType);
        }

        @Override
        public String getAggrFunctionName() {
            return BitmapMeasureType.FUNC_COUNT_DISTINCT;
        }

        @Override
        public String getAggrDataTypeName() {
            return BitmapMeasureType.DATATYPE_BITMAP;
        }

        @Override
        public Class<? extends DataTypeSerializer<BitmapCounter>> getAggrDataTypeSerializer() {
            return BitmapSerializer.class;
        }
    }
}

