/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dimension;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.DimensionEncodingFactory;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntDimEnc
extends DimensionEncoding
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(IntDimEnc.class);
    private static final long[] CAP = new long[]{0L, 255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, Long.MAX_VALUE};
    public static final String ENCODING_NAME = "int";
    private int fixedLen;
    private transient int avoidVerbose = 0;

    public IntDimEnc() {
    }

    public IntDimEnc(int len) {
        if (len <= 0 || len >= CAP.length) {
            throw new IllegalArgumentException();
        }
        this.fixedLen = len;
    }

    @Override
    public int getLengthOfEncoding() {
        return this.fixedLen;
    }

    @Override
    public void encode(String valueStr, byte[] output, int outputOffset) {
        if (valueStr == null) {
            Arrays.fill(output, outputOffset, outputOffset + this.fixedLen, (byte)-1);
            return;
        }
        long integer = Long.parseLong(valueStr);
        if (integer > CAP[this.fixedLen] && this.avoidVerbose++ % 10000 == 0) {
            logger.warn("Expect at most " + this.fixedLen + " bytes, but got " + valueStr + ", will truncate, hit times:" + this.avoidVerbose);
        }
        BytesUtil.writeLong((long)integer, (byte[])output, (int)outputOffset, (int)this.fixedLen);
    }

    @Override
    public String decode(byte[] bytes, int offset, int len) {
        if (IntDimEnc.isNull(bytes, offset, len)) {
            return null;
        }
        long integer = BytesUtil.readLong((byte[])bytes, (int)offset, (int)len);
        return String.valueOf(integer);
    }

    @Override
    public DataTypeSerializer<Object> asDataTypeSerializer() {
        return new IntegerSerializer();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.fixedLen);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fixedLen = in.readShort();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntDimEnc that = (IntDimEnc)o;
        return this.fixedLen == that.fixedLen;
    }

    public int hashCode() {
        return this.fixedLen;
    }

    public class IntegerSerializer
    extends DataTypeSerializer<Object> {
        private byte[] currentBuf() {
            byte[] buf = (byte[])this.current.get();
            if (buf == null) {
                buf = new byte[IntDimEnc.this.fixedLen];
                this.current.set(buf);
            }
            return buf;
        }

        public void serialize(Object value, ByteBuffer out) {
            byte[] buf = this.currentBuf();
            String valueStr = value == null ? null : value.toString();
            IntDimEnc.this.encode(valueStr, buf, 0);
            out.put(buf);
        }

        public Object deserialize(ByteBuffer in) {
            byte[] buf = this.currentBuf();
            in.get(buf);
            return IntDimEnc.this.decode(buf, 0, buf.length);
        }

        @Override
        public int peekLength(ByteBuffer in) {
            return IntDimEnc.this.fixedLen;
        }

        @Override
        public int maxLength() {
            return IntDimEnc.this.fixedLen;
        }

        @Override
        public int getStorageBytesEstimate() {
            return IntDimEnc.this.fixedLen;
        }

        @Override
        public Object valueOf(String str) {
            return str;
        }
    }

    public static class Factory
    extends DimensionEncodingFactory {
        @Override
        public String getSupportedEncodingName() {
            return IntDimEnc.ENCODING_NAME;
        }

        @Override
        public DimensionEncoding createDimensionEncoding(String encodingName, String[] args) {
            return new IntDimEnc(Integer.parseInt(args[0]));
        }
    }
}

