/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.gridtable;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.IDimensionEncodingMap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;

public abstract class GridTableMapping {
    protected List<DataType> gtDataTypes;
    protected List<ImmutableBitSet> gtColBlocks;
    protected int nDimensions;
    protected Map<TblColRef, Integer> dim2gt;
    protected ImmutableBitSet gtPrimaryKey;
    protected int nMetrics;
    protected Map<FunctionDesc, Integer> metrics2gt;

    public int getColumnCount() {
        return this.nDimensions + this.nMetrics;
    }

    public DataType[] getDataTypes() {
        return this.gtDataTypes.toArray(new DataType[this.gtDataTypes.size()]);
    }

    public ImmutableBitSet getPrimaryKey() {
        return this.gtPrimaryKey;
    }

    public int getIndexOf(TblColRef dimension) {
        Integer i = this.dim2gt.get(dimension);
        return i == null ? -1 : i;
    }

    public int[] getDimIndices(Collection<TblColRef> dims) {
        int[] result = new int[dims.size()];
        int i = 0;
        for (TblColRef dim : dims) {
            result[i++] = this.getIndexOf(dim);
        }
        return result;
    }

    public int getIndexOf(FunctionDesc metric) {
        Integer r = this.metrics2gt.get(metric);
        if (r == null) {
            r = this.handlerCountReplace(metric);
        }
        return r == null ? -1 : r;
    }

    public Integer handlerCountReplace(FunctionDesc metric) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (config.isReplaceColCountWithCountStar() && "COUNT".equals(metric.getExpression())) {
            for (FunctionDesc functionDesc : this.metrics2gt.keySet()) {
                if (!"COUNT".equals(functionDesc.getExpression()) || functionDesc.getParameters().size() != 1 || !"1".equals(functionDesc.getParameters().get(0).getValue())) continue;
                return this.metrics2gt.get(functionDesc);
            }
        }
        return null;
    }

    public int[] getMetricsIndices(Collection<FunctionDesc> metrics) {
        int[] result = new int[metrics.size()];
        int i = 0;
        for (FunctionDesc metric : metrics) {
            result[i++] = this.getIndexOf(metric);
        }
        return result;
    }

    public abstract List<TblColRef> getCuboidDimensionsInGTOrder();

    public abstract DimensionEncoding[] getDimensionEncodings(IDimensionEncodingMap var1);

    public abstract Map<Integer, Integer> getDependentMetricsMap();

    public abstract String getTableName();

    public ImmutableBitSet makeGridTableColumns(Set<TblColRef> dimensions) {
        BitSet result = new BitSet();
        for (TblColRef dim : dimensions) {
            int idx = this.getIndexOf(dim);
            if (idx < 0) continue;
            result.set(idx);
        }
        return new ImmutableBitSet(result);
    }

    public ImmutableBitSet makeGridTableColumns(Collection<FunctionDesc> metrics) {
        BitSet result = new BitSet();
        for (FunctionDesc metric : metrics) {
            int idx = this.getIndexOf(metric);
            if (idx < 0) {
                throw new IllegalStateException(metric + " not found in " + this);
            }
            result.set(idx);
        }
        return new ImmutableBitSet(result);
    }

    public String[] makeAggrFuncs(Collection<FunctionDesc> metrics) {
        ArrayList metricList = Lists.newArrayList(metrics);
        metricList.sort((o1, o2) -> {
            int a = this.getIndexOf((FunctionDesc)o1);
            int b = this.getIndexOf((FunctionDesc)o2);
            return a - b;
        });
        String[] result = new String[metricList.size()];
        int i = 0;
        for (FunctionDesc metric : metricList) {
            result[i++] = metric.getExpression();
        }
        return result;
    }
}

