/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@NotThreadSafe
public final class BlockMasterInfo
implements Serializable {
    private static final long serialVersionUID = -7436215337909224255L;
    private long mCapacityBytes;
    private Map<String, Long> mCapacityBytesOnTiers;
    private long mFreeBytes;
    private int mLiveWorkerNum;
    private int mLostWorkerNum;
    private long mUsedBytes;
    private Map<String, Long> mUsedBytesOnTiers;

    public long getCapacityBytes() {
        return this.mCapacityBytes;
    }

    public Map<String, Long> getCapacityBytesOnTiers() {
        return this.mCapacityBytesOnTiers;
    }

    public long getFreeBytes() {
        return this.mFreeBytes;
    }

    public int getLiveWorkerNum() {
        return this.mLiveWorkerNum;
    }

    public int getLostWorkerNum() {
        return this.mLostWorkerNum;
    }

    public long getUsedBytes() {
        return this.mUsedBytes;
    }

    public Map<String, Long> getUsedBytesOnTiers() {
        return this.mUsedBytesOnTiers;
    }

    public BlockMasterInfo setCapacityBytes(long capacityBytes) {
        this.mCapacityBytes = capacityBytes;
        return this;
    }

    public BlockMasterInfo setCapacityBytesOnTiers(Map<String, Long> capacityBytesOnTiers) {
        this.mCapacityBytesOnTiers = new HashMap<String, Long>(capacityBytesOnTiers);
        return this;
    }

    public BlockMasterInfo setFreeBytes(long freeBytes) {
        this.mFreeBytes = freeBytes;
        return this;
    }

    public BlockMasterInfo setLiveWorkerNum(int liveWorkerNum) {
        this.mLiveWorkerNum = liveWorkerNum;
        return this;
    }

    public BlockMasterInfo setLostWorkerNum(int lostWorkerNum) {
        this.mLostWorkerNum = lostWorkerNum;
        return this;
    }

    public BlockMasterInfo setUsedBytes(long usedBytes) {
        this.mUsedBytes = usedBytes;
        return this;
    }

    public BlockMasterInfo setUsedBytesOnTiers(Map<String, Long> usedBytesOnTiers) {
        this.mUsedBytesOnTiers = new HashMap<String, Long>(usedBytesOnTiers);
        return this;
    }

    protected alluxio.grpc.BlockMasterInfo toProto() {
        return alluxio.grpc.BlockMasterInfo.newBuilder().setCapacityBytes(this.mCapacityBytes).putAllCapacityBytesOnTiers(this.mCapacityBytesOnTiers).setFreeBytes(this.mFreeBytes).setLiveWorkerNum(this.mLiveWorkerNum).setLostWorkerNum(this.mLostWorkerNum).setUsedBytes(this.mUsedBytes).putAllUsedBytesOnTiers(this.mUsedBytesOnTiers).build();
    }

    public static BlockMasterInfo fromProto(alluxio.grpc.BlockMasterInfo info) {
        return new BlockMasterInfo().setCapacityBytes(info.getCapacityBytes()).setCapacityBytesOnTiers(info.getCapacityBytesOnTiersMap()).setFreeBytes(info.getFreeBytes()).setLiveWorkerNum(info.getLiveWorkerNum()).setLostWorkerNum(info.getLostWorkerNum()).setUsedBytes(info.getUsedBytes()).setUsedBytesOnTiers(info.getUsedBytesOnTiersMap());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockMasterInfo)) {
            return false;
        }
        BlockMasterInfo that = (BlockMasterInfo)o;
        return this.mCapacityBytes == that.mCapacityBytes && Objects.equal(this.mCapacityBytesOnTiers, that.mCapacityBytesOnTiers) && this.mFreeBytes == that.mFreeBytes && this.mLiveWorkerNum == that.mLiveWorkerNum && this.mLostWorkerNum == that.mLostWorkerNum && this.mUsedBytes == that.mUsedBytes && Objects.equal(this.mUsedBytesOnTiers, that.mUsedBytesOnTiers);
    }

    public int hashCode() {
        return Objects.hashCode(this.mCapacityBytes, this.mCapacityBytesOnTiers, this.mFreeBytes, this.mLiveWorkerNum, this.mLostWorkerNum, this.mUsedBytes, this.mUsedBytesOnTiers);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("capacityBytes", this.mCapacityBytes).add("capacityBytesOnTiers", this.mCapacityBytesOnTiers).add("freeBytes", this.mFreeBytes).add("liveWorkerNum", this.mLiveWorkerNum).add("lostWorkerNum", this.mLostWorkerNum).add("usedBytes", this.mUsedBytes).add("usedBytesOnTiers", this.mUsedBytesOnTiers).toString();
    }

    public static enum BlockMasterInfoField {
        CAPACITY_BYTES,
        CAPACITY_BYTES_ON_TIERS,
        FREE_BYTES,
        LIVE_WORKER_NUM,
        LOST_WORKER_NUM,
        USED_BYTES,
        USED_BYTES_ON_TIERS;


        public alluxio.grpc.BlockMasterInfoField toProto() {
            return alluxio.grpc.BlockMasterInfoField.valueOf(this.name());
        }

        public static BlockMasterInfoField fromProto(alluxio.grpc.BlockMasterInfoField field) {
            return BlockMasterInfoField.valueOf(field.name());
        }
    }
}

