/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.util;

import java.util.Objects;
import java.util.function.Supplier;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.util.ColumnMappingVisitor;
import org.mybatis.dynamic.sql.util.PropertyMapping;

public class PropertyWhenPresentMapping
extends PropertyMapping {
    private final Supplier<?> valueSupplier;

    private PropertyWhenPresentMapping(SqlColumn<?> column, String property, Supplier<?> valueSupplier) {
        super(column, property);
        this.valueSupplier = Objects.requireNonNull(valueSupplier);
    }

    public boolean shouldRender() {
        return this.valueSupplier.get() != null;
    }

    @Override
    public <R> R accept(ColumnMappingVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public static PropertyWhenPresentMapping of(SqlColumn<?> column, String property, Supplier<?> valueSupplier) {
        return new PropertyWhenPresentMapping(column, property, valueSupplier);
    }
}

