/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.select.PagingModel;
import org.mybatis.dynamic.sql.select.render.FetchFirstPagingModelRenderer;
import org.mybatis.dynamic.sql.select.render.LimitAndOffsetPagingModelRenderer;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;

public class PagingModelRenderer {
    private final RenderingStrategy renderingStrategy;
    private final PagingModel pagingModel;
    private final AtomicInteger sequence;

    private PagingModelRenderer(Builder builder) {
        this.renderingStrategy = Objects.requireNonNull(builder.renderingStrategy);
        this.pagingModel = Objects.requireNonNull(builder.pagingModel);
        this.sequence = Objects.requireNonNull(builder.sequence);
    }

    public FragmentAndParameters render() {
        return this.pagingModel.limit().map(this::limitAndOffsetRender).orElseGet(this::fetchFirstRender);
    }

    private FragmentAndParameters limitAndOffsetRender(Long limit) {
        return new LimitAndOffsetPagingModelRenderer(this.renderingStrategy, limit, this.pagingModel, this.sequence).render();
    }

    private FragmentAndParameters fetchFirstRender() {
        return new FetchFirstPagingModelRenderer(this.renderingStrategy, this.pagingModel, this.sequence).render();
    }

    public static class Builder {
        private RenderingStrategy renderingStrategy;
        private PagingModel pagingModel;
        private AtomicInteger sequence;

        public Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public Builder withPagingModel(PagingModel pagingModel) {
            this.pagingModel = pagingModel;
            return this;
        }

        public Builder withSequence(AtomicInteger sequence) {
            this.sequence = sequence;
            return this;
        }

        public PagingModelRenderer build() {
            return new PagingModelRenderer(this);
        }
    }
}

