/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql;

import java.util.Objects;
import java.util.Optional;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;

public class StringConstant
implements BindableColumn<String> {
    private final String alias;
    private final String value;

    private StringConstant(String value) {
        this(value, null);
    }

    private StringConstant(String value, String alias) {
        this.value = Objects.requireNonNull(value);
        this.alias = alias;
    }

    @Override
    public Optional<String> alias() {
        return Optional.ofNullable(this.alias);
    }

    @Override
    public String renderWithTableAlias(TableAliasCalculator tableAliasCalculator) {
        return "'" + this.value + "'";
    }

    @Override
    public StringConstant as(String alias) {
        return new StringConstant(this.value, alias);
    }

    public static StringConstant of(String value) {
        return new StringConstant(value);
    }
}

