/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.pushdown;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.kylin.cache.kylin.KylinCacheFileSystem;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.engine.spark.QueryCostCollector;
import org.apache.kylin.fileseg.FileSegments;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.query.StructField;
import org.apache.kylin.query.mask.QueryResultMasks;
import org.apache.kylin.query.pushdown.SparkSqlClient;
import org.apache.kylin.query.runtime.plan.QueryToExecutionIDCache$;
import org.apache.kylin.query.runtime.plan.ResultPlan$;
import org.apache.kylin.query.util.QueryInterruptChecker;
import org.apache.kylin.query.util.SparkJobTrace;
import org.apache.kylin.query.util.SparkJobTrace$;
import org.apache.kylin.softaffinity.SoftAffinityManager$;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparderEnv$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.hive.QueryMetricUtils$;
import org.apache.spark.sql.hive.utils.ResourceDetectUtils$;
import org.apache.spark.sql.util.SparderTypeUtil$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.WrappedArray;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class SparkSqlClient$ {
    public static SparkSqlClient$ MODULE$;
    private final String DEFAULT_DB;
    private final String SHUFFLE_PARTITION;
    private final Logger logger;

    static {
        new SparkSqlClient$();
    }

    public String DEFAULT_DB() {
        return this.DEFAULT_DB;
    }

    public String SHUFFLE_PARTITION() {
        return this.SHUFFLE_PARTITION;
    }

    public Logger logger() {
        return this.logger;
    }

    public Pair<List<List<String>>, List<StructField>> executeSql(SparkSession ss, String sql, UUID uuid, String project) {
        Tuple3<Iterable<List<String>>, Object, List<StructField>> results = this.executeSqlToIterable(ss, sql, uuid, project);
        return Pair.newPair((Object)ImmutableList.copyOf((Iterable)((Iterable)results._1())), (Object)results._3());
    }

    public Tuple3<Iterable<List<String>>, Object, List<StructField>> executeSqlToIterable(SparkSession ss, String sql, UUID uuid, String project) {
        Tuple3 tuple3;
        ss.sparkContext().setLocalProperty("spark.scheduler.pool", "query_pushdown");
        HadoopUtil.setCurrentConfiguration((Configuration)ss.sparkContext().hadoopConfiguration());
        String queryId = QueryContext.current().getQueryId();
        ss.sparkContext().setLocalProperty(QueryToExecutionIDCache$.MODULE$.KYLIN_QUERY_ID_KEY(), queryId);
        this.logger().info("Start to run sql with SparkSQL...");
        try {
            Tuple3 tuple32;
            KylinCacheFileSystem.processAcceptCacheTimeInHintStr((String)QueryContext.current().getFirstHintStr());
            String db = StringUtils.isNotBlank((CharSequence)project) ? NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getDefaultDatabase(project) : null;
            ss.sessionState().conf().setLocalProperty(this.DEFAULT_DB(), db);
            Dataset dfOfPushDown = ss.sql(sql);
            if (NProjectManager.getProjectConfig((String)project).isPrintQueryPlanEnabled()) {
                this.logger().info(dfOfPushDown.queryExecution().logical().toString());
            }
            Dataset<Row> df = QueryResultMasks.maskResult((Dataset<Row>)dfOfPushDown);
            this.logger().info("SparkSQL returned result DataFrame");
            QueryContext.current().record("to_spark_plan");
            this.autoSetShufflePartitions(df);
            QueryContext.current().record("auto_set_parts");
            if (FileSegments.isSyncFileSegSql((String)sql)) {
                int nParts = df.rdd().getNumPartitions();
                tuple32 = new Tuple3((Object)ImmutableList.of((Object)ImmutableList.of((Object)Integer.toString(nParts))), (Object)BoxesRunTime.boxToInteger((int)1), (Object)ImmutableList.of((Object)new StructField("CNT", -5, "BIGINT", 0, 0, false)));
            } else {
                tuple32 = this.dfToList(ss, sql, df);
            }
            Tuple3 iter = tuple32;
            QueryContext.current().record("collect_result");
            SoftAffinityManager$.MODULE$.logAuditAsks();
            tuple3 = iter;
        }
        finally {
            ss.sessionState().conf().setLocalProperty(this.DEFAULT_DB(), null);
            KylinCacheFileSystem.clearAcceptCacheTimeLocally();
        }
        return tuple3;
    }

    private void autoSetShufflePartitions(Dataset<Row> df) {
        boolean isSkip;
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        int oriShufflePartition = new StringOps(Predef$.MODULE$.augmentString(df.sparkSession().sessionState().conf().getConfString(this.SHUFFLE_PARTITION()))).toInt();
        boolean bl = isSkip = !config.isAutoSetPushDownPartitions() || !ResourceDetectUtils$.MODULE$.checkPartitionFilter(df.queryExecution().sparkPlan());
        if (isSkip) {
            this.logger().info(new StringBuilder(33).append("Skip auto set ").append(this.SHUFFLE_PARTITION()).append(", use origin value ").append(oriShufflePartition).toString());
            return;
        }
        int forced = config.autoSetPushDownPartitionsForced();
        if (forced > 0) {
            df.sparkSession().sessionState().conf().setLocalProperty(this.SHUFFLE_PARTITION(), Integer.toString(forced));
            QueryContext.current().setShufflePartitions(forced);
            this.logger().info(new StringBuilder(51).append("Auto force set forced spark.sql.shuffle.partitions ").append(forced).toString());
            return;
        }
        boolean isConcurrency = config.isConcurrencyFetchDataSourceSize();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        int timeOut = config.getAutoShufflePartitionTimeOut();
        Future<BoxedUnit> future = executor.submit(new Callable<BoxedUnit>(config, df, isConcurrency, timeOut){
            private final KylinConfig config$1;
            private final Dataset df$1;
            private final boolean isConcurrency$1;
            private final int timeOut$1;

            public void call() {
                int basePartitionSize = this.config$1.getBaseShufflePartitionSize();
                Seq paths = ResourceDetectUtils$.MODULE$.getPaths(this.df$1.queryExecution().sparkPlan(), ResourceDetectUtils$.MODULE$.getPaths$default$2());
                String sourceTableSize = "";
                sourceTableSize = this.isConcurrency$1 ? new StringBuilder(1).append(ResourceDetectUtils$.MODULE$.getResourceSizeWithTimeoutByConcurrency(this.config$1, (Duration)Duration$.MODULE$.apply((long)this.timeOut$1, TimeUnit.SECONDS), SparderEnv$.MODULE$.getHadoopConfiguration(), paths)).append("b").toString() : new StringBuilder(1).append(ResourceDetectUtils$.MODULE$.getResourceSizBySerial(this.config$1, SparderEnv$.MODULE$.getHadoopConfiguration(), paths)).append("b").toString();
                String partitions = Long.toString(Math.max(1L, JavaUtils.byteStringAsMb((String)sourceTableSize) / (long)basePartitionSize));
                this.df$1.sparkSession().sessionState().conf().setLocalProperty(SparkSqlClient$.MODULE$.SHUFFLE_PARTITION(), partitions);
                QueryContext.current().setShufflePartitions(new StringOps(Predef$.MODULE$.augmentString(partitions)).toInt());
                SparkSqlClient$.MODULE$.logger().info(new StringBuilder(48).append("Auto set ").append(SparkSqlClient$.MODULE$.SHUFFLE_PARTITION()).append(" ").append(partitions).append(", ").append("sourceTableSize ").append(sourceTableSize).append(", basePartitionSize ").append(basePartitionSize).toString());
            }
            {
                this.config$1 = config$1;
                this.df$1 = df$1;
                this.isConcurrency$1 = isConcurrency$1;
                this.timeOut$1 = timeOut$1;
            }
        });
        try {
            try {
                future.get(timeOut, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                int oriShufflePartition2 = new StringOps(Predef$.MODULE$.augmentString(df.sparkSession().sessionState().conf().getConfString(this.SHUFFLE_PARTITION()))).toInt();
                int partitions = oriShufflePartition2 * config.getAutoShufflePartitionMultiple();
                df.sparkSession().sessionState().conf().setLocalProperty(this.SHUFFLE_PARTITION(), Integer.toString(partitions));
                QueryContext.current().setShufflePartitions(partitions);
                this.logger().info(new StringBuilder(43).append("Auto set shuffle partitions timeout. set ").append(this.SHUFFLE_PARTITION()).append(" ").append(partitions).append(".").toString());
            }
            catch (Exception e) {
                this.logger().error(new StringBuilder(17).append("Auto set ").append(this.SHUFFLE_PARTITION()).append(" failed.").toString(), (Throwable)e);
                throw e;
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    public Tuple3<Iterable<List<String>>, Object, List<StructField>> dfToList(SparkSession ss, String sql, Dataset<Row> df) {
        Tuple3 tuple3;
        block12: {
            Tuple3 tuple32;
            block11: {
                KapConfig config = KapConfig.getInstanceFromEnv();
                String jobGroup = Thread.currentThread().getName();
                ss.sparkContext().setJobGroup(jobGroup, new StringBuilder(11).append("Push down: ").append(sql).toString(), true);
                try {
                    try {
                        QueryContext.QueryTagInfo queryTagInfo = QueryContext.current().getQueryTagInfo();
                        if (queryTagInfo.isAsyncQuery()) {
                            List fieldList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)df.schema().map((Function1 & Serializable & scala.Serializable)field -> SparderTypeUtil$.MODULE$.convertSparkFieldToJavaField(field), Seq$.MODULE$.canBuildFrom())).asJava();
                            List columnNames = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fieldList).asScala()).map((Function1 & Serializable & scala.Serializable)field -> field.getName(), Buffer$.MODULE$.canBuildFrom())).asJava();
                            QueryContext.current().setColumnNames(columnNames);
                            ResultPlan$.MODULE$.saveAsyncQueryResult(df, queryTagInfo.getFileFormat(), queryTagInfo.getFileEncode(), null);
                            tuple32 = new Tuple3((Object)Lists.newArrayList(), (Object)BoxesRunTime.boxToInteger((int)0), (Object)fieldList);
                            break block11;
                        }
                        if (QueryContext.current().isExplainSql()) {
                            List fieldList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)df.schema().map((Function1 & Serializable & scala.Serializable)field -> SparderTypeUtil$.MODULE$.convertSparkFieldToJavaField(field), Seq$.MODULE$.canBuildFrom())).asJava();
                            QueryContext.current().getQueryPlan().setSparkPlan(df.queryExecution().analyzed().toString());
                            tuple32 = new Tuple3((Object)Lists.newArrayList(), (Object)BoxesRunTime.boxToInteger((int)0), (Object)fieldList);
                            break block11;
                        }
                        QueryContext.currentTrace().endLastSpan();
                        SparkJobTrace jobTrace = new SparkJobTrace(jobGroup, QueryContext.currentTrace(), QueryContext.current().getQueryId(), SparderEnv$.MODULE$.getSparkSession().sparkContext(), SparkJobTrace$.MODULE$.$lessinit$greater$default$5());
                        NProjectManager.getProjectConfig((String)QueryContext.current().getProject()).isQueryUseIterableCollectApi();
                        Tuple2 results = NProjectManager.getProjectConfig((String)QueryContext.current().getProject()).isQueryUseIterableCollectApi() ? df.collectToIterator() : df.toIterator();
                        Iterator resultRows = (Iterator)results._1();
                        int resultSize = results._2$mcI$sp();
                        if (config.isQuerySparkJobTraceEnabled()) {
                            jobTrace.jobFinished();
                        }
                        List fieldList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)df.schema().map((Function1 & Serializable & scala.Serializable)field -> SparderTypeUtil$.MODULE$.convertSparkFieldToJavaField(field), Seq$.MODULE$.canBuildFrom())).asJava();
                        Tuple2<List<Long>, List<Long>> tuple2 = QueryMetricUtils$.MODULE$.collectScanMetrics(df.queryExecution().executedPlan());
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        List scanRows = (List)tuple2._1();
                        List scanBytes = (List)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)scanRows, (Object)scanBytes);
                        Tuple2 tuple23 = tuple22;
                        List scanRows2 = (List)tuple23._1();
                        List scanBytes2 = (List)tuple23._2();
                        Tuple3<Long, Long, Long> tuple33 = QueryMetricUtils$.MODULE$.collectTaskRelatedMetrics(jobGroup, ss.sparkContext());
                        if (tuple33 == null) {
                            throw new MatchError(tuple33);
                        }
                        Long jobCount = (Long)tuple33._1();
                        Long stageCount = (Long)tuple33._2();
                        Long taskCount = (Long)tuple33._3();
                        Tuple3 tuple34 = new Tuple3((Object)jobCount, (Object)stageCount, (Object)taskCount);
                        Tuple3 tuple35 = tuple34;
                        Long jobCount2 = (Long)tuple35._1();
                        Long stageCount2 = (Long)tuple35._2();
                        Long taskCount2 = (Long)tuple35._3();
                        QueryContext.current().getMetrics().setScanRows(scanRows2);
                        QueryContext.current().getMetrics().setScanBytes(scanBytes2);
                        QueryContext.current().getMetrics().setQueryJobCount(Predef$.MODULE$.Long2long(jobCount2));
                        QueryContext.current().getMetrics().setQueryStageCount(Predef$.MODULE$.Long2long(stageCount2));
                        QueryContext.current().getMetrics().setQueryTaskCount(Predef$.MODULE$.Long2long(taskCount2));
                        QueryContext.current().getMetrics().setCpuTime(QueryCostCollector.getAndCleanStatus((String)QueryContext.current().getQueryId()));
                        tuple3 = new Tuple3(this.readPushDownResultRow(resultRows, true), (Object)BoxesRunTime.boxToInteger((int)resultSize), (Object)fieldList);
                        break block12;
                    }
                    catch (Throwable e) {
                        if (e instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                            ss.sparkContext().cancelJobGroup(jobGroup);
                            QueryInterruptChecker.checkThreadInterrupted((String)"Interrupted at the stage of collecting result in SparkSqlClient.", (String)"Current step: Collecting dataset of push-down.");
                        }
                        throw e;
                    }
                }
                finally {
                    QueryContext.current().setExecutionID(QueryToExecutionIDCache$.MODULE$.getQueryExecutionID(QueryContext.current().getQueryId()));
                    df.sparkSession().sessionState().conf().setLocalProperty(this.SHUFFLE_PARTITION(), null);
                    HadoopUtil.setCurrentConfiguration(null);
                }
            }
            return tuple32;
        }
        return tuple3;
    }

    public Iterable<List<String>> readPushDownResultRow(Iterator<Row> resultRows, boolean checkInterrupt) {
        return () -> new Iterator<List<String>>(resultRows, checkInterrupt){
            private final int checkInterruptSize;
            private int readRowSize;
            private final Iterator resultRows$1;
            private final boolean checkInterrupt$1;

            public void remove() {
                Iterator.super.remove();
            }

            public void forEachRemaining(Consumer<? super List<String>> x$1) {
                Iterator.super.forEachRemaining(x$1);
            }

            private int checkInterruptSize() {
                return this.checkInterruptSize;
            }

            private int readRowSize() {
                return this.readRowSize;
            }

            private void readRowSize_$eq(int x$1) {
                this.readRowSize = x$1;
            }

            public boolean hasNext() {
                return this.resultRows$1.hasNext();
            }

            public List<String> next() {
                Row row;
                block0: {
                    row = (Row)this.resultRows$1.next();
                    this.readRowSize_$eq(this.readRowSize() + 1);
                    if (!this.checkInterrupt$1 || this.readRowSize() % this.checkInterruptSize() != 0) break block0;
                    QueryInterruptChecker.checkThreadInterrupted((String)"Interrupted at the stage of collecting result in SparkSqlClient.", (String)"Current step: Collecting dataset of push-down.");
                }
                return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)row.toSeq().map((Function1 & Serializable & scala.Serializable)x$3 -> SparkSqlClient$.MODULE$.org$apache$kylin$query$pushdown$SparkSqlClient$$rawValueToString(x$3, SparkSqlClient$.MODULE$.org$apache$kylin$query$pushdown$SparkSqlClient$$rawValueToString$default$2()), Seq$.MODULE$.canBuildFrom())).asJava();
            }
            {
                this.resultRows$1 = resultRows$1;
                this.checkInterrupt$1 = checkInterrupt$1;
                this.checkInterruptSize = 1000;
                this.readRowSize = 0;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$next$1(java.lang.Object )}, serializedLambda);
            }
        };
    }

    public String org$apache$kylin$query$pushdown$SparkSqlClient$$rawValueToString(Object value, boolean wrapped) {
        String string;
        Object object = value;
        if (object == null) {
            string = null;
        } else if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            string = DateFormat.castTimestampToString((long)timestamp.getTime());
        } else if (object instanceof String) {
            String string2 = (String)object;
            string = wrapped ? new StringBuilder(2).append("\"").append(string2).append("\"").toString() : string2;
        } else if (object instanceof WrappedArray) {
            WrappedArray wrappedArray = (WrappedArray)object;
            string = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(wrappedArray.array()).map((Function1 & Serializable & scala.Serializable)v -> MODULE$.org$apache$kylin$query$pushdown$SparkSqlClient$$rawValueToString(v, true), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ",", "]");
        } else if (object instanceof WrappedArray.ofRef) {
            WrappedArray.ofRef ofRef2 = (WrappedArray.ofRef)object;
            string = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(ofRef2.array())).map((Function1 & Serializable & scala.Serializable)v -> MODULE$.org$apache$kylin$query$pushdown$SparkSqlClient$$rawValueToString(v, true), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ",", "]");
        } else if (object instanceof Map) {
            Map map = (Map)object;
            string = ((TraversableOnce)map.map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(1).append(MODULE$.org$apache$kylin$query$pushdown$SparkSqlClient$$rawValueToString(p._1(), true)).append(":").append(MODULE$.org$apache$kylin$query$pushdown$SparkSqlClient$$rawValueToString(p._2(), true)).toString(), Iterable$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            string = new String(byArray, StandardCharsets.UTF_8);
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            string = SparderTypeUtil$.MODULE$.adjustDecimal(bigDecimal);
        } else if (object instanceof Object) {
            Object object2 = object;
            string = object2.toString();
        } else {
            throw new MatchError(object);
        }
        return string;
    }

    public boolean org$apache$kylin$query$pushdown$SparkSqlClient$$rawValueToString$default$2() {
        return false;
    }

    private SparkSqlClient$() {
        MODULE$ = this;
        this.DEFAULT_DB = "spark.sql.default.database";
        this.SHUFFLE_PARTITION = "spark.sql.shuffle.partitions";
        this.logger = LoggerFactory.getLogger(SparkSqlClient.class);
    }
}

